/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.OExtractedItem;
import com.orientechnologies.orient.etl.context.OETLContext;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.loader.OLoader;
import com.orientechnologies.orient.etl.transformer.OTransformer;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import java.util.List;

public class OETLPipeline {
    protected final OETLProcessor processor;
    protected final List<OTransformer> transformers;
    protected final OLoader loader;
    protected final OCommandContext context;
    protected final OETLProcessor.LOG_LEVELS logLevel;
    protected final int maxRetries;
    protected boolean haltOnError;
    protected ODatabaseDocument db;
    protected OrientBaseGraph graph;

    public OETLPipeline(OETLProcessor processor, List<OTransformer> transformers, OLoader loader, OETLProcessor.LOG_LEVELS logLevel, int maxRetries, boolean haltOnError) {
        this.processor = processor;
        this.transformers = transformers;
        this.loader = loader;
        this.logLevel = logLevel;
        this.maxRetries = maxRetries;
        this.haltOnError = haltOnError;
        this.context = new OETLContext();
        for (OTransformer t : this.transformers) {
            t.setPipeline(this);
        }
    }

    public synchronized void begin() {
        this.loader.beginLoader(this);
        for (OTransformer t : this.transformers) {
            t.begin();
        }
    }

    public ODatabaseDocument getDocumentDatabase() {
        if (this.db != null) {
            this.db.activateOnCurrentThread();
        }
        return this.db;
    }

    public OETLPipeline setDocumentDatabase(ODatabaseDocument iDb) {
        this.db = iDb;
        return this;
    }

    public OrientBaseGraph getGraphDatabase() {
        if (this.graph != null) {
            this.graph.makeActive();
        }
        return this.graph;
    }

    public OETLPipeline setGraphDatabase(OrientBaseGraph iGraph) {
        this.graph = iGraph;
        return this;
    }

    public OCommandContext getContext() {
        return this.context;
    }

    protected Object execute(OExtractedItem source) {
        int retry = 0;
        do {
            try {
                Object current = source.payload;
                this.context.setVariable("extractedNum", (Object)source.num);
                this.context.setVariable("extractedPayload", source.payload);
                for (OTransformer t : this.transformers) {
                    current = t.transform(current);
                    if (current != null) continue;
                    OETLContextWrapper.getInstance().getMessageHandler().warn((Object)this, "Transformer [%s] returned null, skip rest of pipeline execution", new Object[]{t});
                }
                if (current != null) {
                    this.loader.load(this, current, this.context);
                }
                return current;
            }
            catch (ONeedRetryException e) {
                this.loader.rollback(this);
                OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "Error in pipeline execution, retry = %d/%d (exception=)", new Object[]{++retry, this.maxRetries, e});
            }
            catch (OETLProcessHaltedException e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Pipeline execution halted");
                this.processor.getStats().incrementErrors();
                this.loader.rollback(this);
                throw e;
            }
            catch (Exception e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error in Pipeline execution:", new Object[]{e});
                this.processor.getStats().incrementErrors();
                if (!this.haltOnError) {
                    return null;
                }
                this.loader.rollback(this);
                throw OException.wrapException((OException)new OETLProcessHaltedException("Halt"), (Throwable)e);
            }
        } while (retry < this.maxRetries);
        return this;
    }

    public void end() {
        this.loader.endLoader(this);
    }
}

