/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.config.properties.PropertyTypeConverter;
import com.hazelcast.config.properties.SimplePropertyDefinition;
import com.hazelcast.config.properties.ValidationException;
import com.hazelcast.config.properties.ValueValidator;
import com.hazelcast.core.TypeConverter;

public enum AwsProperties {
    ACCESS_KEY("access-key", PropertyTypeConverter.STRING, true),
    SECRET_KEY("secret-key", PropertyTypeConverter.STRING, true),
    REGION("region", PropertyTypeConverter.STRING, true),
    IAM_ROLE("iam-role", PropertyTypeConverter.STRING, true),
    HOST_HEADER("host-header", PropertyTypeConverter.STRING, true),
    SECURITY_GROUP_NAME("security-group-name", PropertyTypeConverter.STRING, true),
    TAG_KEY("tag-key", PropertyTypeConverter.STRING, true),
    TAG_VALUE("tag-value", PropertyTypeConverter.STRING, true),
    CONNECTION_TIMEOUT_SECONDS("connection-timeout-seconds", PropertyTypeConverter.INTEGER, true),
    PORT("hz-port", PropertyTypeConverter.INTEGER, true, new PortValueValidator());

    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private final PropertyDefinition propertyDefinition;

    private AwsProperties(String key, PropertyTypeConverter typeConverter, boolean optional, ValueValidator validator) {
        this.propertyDefinition = new SimplePropertyDefinition(key, optional, (TypeConverter)typeConverter, validator);
    }

    private AwsProperties(String key, PropertyTypeConverter typeConverter, boolean optional) {
        this.propertyDefinition = new SimplePropertyDefinition(key, optional, (TypeConverter)typeConverter);
    }

    public PropertyDefinition getDefinition() {
        return this.propertyDefinition;
    }

    public static class PortValueValidator
    implements ValueValidator<Integer> {
        public void validate(Integer value) throws ValidationException {
            if (value < 0) {
                throw new ValidationException("hz-port number must be greater 0");
            }
            if (value > 65535) {
                throw new ValidationException("hz-port number must be less or equal to 65535");
            }
        }
    }
}

