/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Arrays;
import java.util.Iterator;

public class VerticesVerticesPipe
extends AbstractPipe<Vertex, Vertex>
implements TransformPipe<Vertex, Vertex> {
    protected int branchFactor;
    protected Direction direction;
    protected String[] labels;
    protected Iterator<Vertex> nextEnds = PipeHelper.emptyIterator();
    private final boolean doBranchFactor;

    public VerticesVerticesPipe(Direction direction, String ... labels) {
        this(direction, Integer.MAX_VALUE, labels);
    }

    public VerticesVerticesPipe(Direction direction, int branchFactor, String ... labels) {
        this.direction = direction;
        this.branchFactor = branchFactor;
        this.labels = labels;
        this.doBranchFactor = branchFactor != Integer.MAX_VALUE;
    }

    @Override
    public void reset() {
        this.nextEnds = PipeHelper.emptyIterator();
        super.reset();
    }

    @Override
    protected Vertex processNextStart() {
        while (!this.nextEnds.hasNext()) {
            this.nextEnds = this.doBranchFactor ? ((Vertex)this.starts.next()).query().direction(this.direction).labels(this.labels).limit(this.branchFactor).vertices().iterator() : ((Vertex)this.starts.next()).getVertices(this.direction, this.labels).iterator();
        }
        return this.nextEnds.next();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public int getBranchFactor() {
        return this.branchFactor;
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, this.direction.name().toLowerCase(), Arrays.asList(this.labels));
    }
}

