/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OSBTreeBonsaiRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OSBTFetchEntriesMajorResponse<K, V>
implements OBinaryResponse {
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;
    private List<Map.Entry<K, V>> list;

    public OSBTFetchEntriesMajorResponse(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public OSBTFetchEntriesMajorResponse(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, List<Map.Entry<K, V>> list) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.list = list;
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        byte[] stream = network.readBytes();
        int offset = 0;
        int count = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, 0);
        offset += 4;
        this.list = new ArrayList<Map.Entry<K, V>>(count);
        for (int i = 0; i < count; ++i) {
            Object resultKey = this.keySerializer.deserialize(stream, offset);
            offset += this.keySerializer.getObjectSize(stream, offset);
            Object resultValue = this.valueSerializer.deserialize(stream, offset);
            offset += this.valueSerializer.getObjectSize(stream, offset);
            this.list.add(new OSBTreeBonsaiRemote.TreeEntry<Object, Object>(resultKey, resultValue));
        }
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        byte[] stream = new byte[4 + this.list.size() * (this.keySerializer.getFixedLength() + this.valueSerializer.getFixedLength())];
        int offset = 0;
        OIntegerSerializer.INSTANCE.serializeLiteral(this.list.size(), stream, offset);
        offset += 4;
        for (Map.Entry<K, V> entry : this.list) {
            this.keySerializer.serialize(entry.getKey(), stream, offset, new Object[0]);
            this.valueSerializer.serialize(entry.getValue(), stream, offset += this.keySerializer.getObjectSize(entry.getKey(), new Object[0]), new Object[0]);
            offset += this.valueSerializer.getObjectSize(entry.getValue(), new Object[0]);
        }
        channel.writeBytes(stream);
    }

    public List<Map.Entry<K, V>> getList() {
        return this.list;
    }
}

