/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OConnect37Request;
import com.orientechnologies.orient.client.remote.message.OConnectResponse;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusResponse;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OListDatabasesRequest;
import com.orientechnologies.orient.client.remote.message.OListDatabasesResponse;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsRequest;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsResponse;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OServerInfoRequest;
import com.orientechnologies.orient.client.remote.message.OServerInfoResponse;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationResponse;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OrientDBRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.util.OURLConnection;
import com.orientechnologies.orient.core.util.OURLHelper;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.Map;

@Deprecated
public class OServerAdmin {
    protected OStorageRemote storage;
    protected OStorageRemoteSession session = new OStorageRemoteSession(-1);
    protected String clientType = "OrientDB Java";
    protected boolean collectStats = true;

    @Deprecated
    public OServerAdmin(String iURL) throws IOException {
        String url = iURL;
        if (url.startsWith("remote")) {
            url = url.substring("remote".length() + 1);
        }
        if (!url.contains("/")) {
            url = url + "/";
        }
        OURLConnection connection = OURLHelper.parse((String)iURL);
        OrientDBRemote remote = (OrientDBRemote)ODatabaseDocumentTxInternal.getOrCreateRemoteFactory((String)connection.getPath());
        this.storage = new OStorageRemote(url, null, "", remote.getConnectionManager(), OStorage.STATUS.OPEN){

            @Override
            protected OStorageRemoteSession getCurrentSession() {
                return OServerAdmin.this.session;
            }
        };
    }

    public OServerAdmin(OrientDBRemote remote, String url) throws IOException {
        ORemoteConnectionManager connectionManager = remote.getConnectionManager();
        this.storage = new OStorageRemote(url, null, "", connectionManager, OStorage.STATUS.OPEN){

            @Override
            protected OStorageRemoteSession getCurrentSession() {
                return OServerAdmin.this.session;
            }
        };
    }

    @Deprecated
    public OServerAdmin(OStorageRemote iStorage) {
        this.storage = iStorage;
    }

    @Deprecated
    public synchronized OServerAdmin connect(String iUserName, String iUserPassword) throws IOException {
        String password;
        String username;
        OCredentialInterceptor ci = OSecurityManager.instance().newCredentialInterceptor();
        if (ci != null) {
            ci.intercept(this.storage.getURL(), iUserName, iUserPassword);
            username = ci.getUsername();
            password = ci.getPassword();
        } else {
            username = iUserName;
            password = iUserPassword;
        }
        OConnect37Request request = new OConnect37Request(username, password);
        this.networkAdminOperation((OChannelBinaryAsynchClient network, OStorageRemoteSession session) -> {
            OStorageRemoteNodeSession nodeSession = session.getOrCreateServerSession(network.getServerURL());
            try {
                network.beginRequest(request.getCommand(), session);
                request.write((OChannelDataOutput)network, session);
            }
            finally {
                network.endRequest();
            }
            OConnectResponse response = request.createResponse();
            try {
                network.beginResponse(nodeSession.getSessionId(), true);
                response.read((OChannelDataInput)network, session);
            }
            finally {
                this.storage.endResponse(network);
            }
            return null;
        }, "Cannot connect to the remote server/database '" + this.storage.getURL() + "'");
        return this;
    }

    @Deprecated
    public synchronized Map<String, String> listDatabases() throws IOException {
        OListDatabasesRequest request = new OListDatabasesRequest();
        OListDatabasesResponse response = this.networkAdminOperation(request, "Cannot retrieve the configuration list");
        return response.getDatabases();
    }

    @Deprecated
    public synchronized ODocument getServerInfo() throws IOException {
        OServerInfoRequest request = new OServerInfoRequest();
        OServerInfoResponse response = this.networkAdminOperation(request, "Cannot retrieve server information");
        ODocument res = new ODocument();
        res.fromJSON(response.getResult());
        return res;
    }

    public int getSessionId() {
        return this.session.getSessionId();
    }

    @Deprecated
    public synchronized OServerAdmin createDatabase(String iStorageMode) throws IOException {
        return this.createDatabase("document", iStorageMode);
    }

    @Deprecated
    public synchronized OServerAdmin createDatabase(String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(this.storage.getName(), iDatabaseType, iStorageMode);
    }

    public synchronized String getStorageName() {
        return this.storage.getName();
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseName, String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(iDatabaseName, iDatabaseType, iStorageMode, null);
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseName, String iDatabaseType, String iStorageMode, String backupPath) throws IOException {
        if (iDatabaseName == null || iDatabaseName.length() <= 0) {
            String message = "Cannot create unnamed remote storage. Check your syntax";
            OLogManager.instance().error((Object)this, "Cannot create unnamed remote storage. Check your syntax", null, new Object[0]);
            throw new OStorageException("Cannot create unnamed remote storage. Check your syntax");
        }
        String storageMode = iStorageMode == null ? "plocal" : iStorageMode;
        OCreateDatabaseRequest request = new OCreateDatabaseRequest(iDatabaseName, iDatabaseName, storageMode, backupPath);
        OCreateDatabaseResponse oCreateDatabaseResponse = this.networkAdminOperation(request, "Cannot create the remote storage: " + this.storage.getName());
        return this;
    }

    public synchronized boolean existsDatabase() throws IOException {
        return this.existsDatabase(null);
    }

    public synchronized boolean existsDatabase(String iDatabaseName, String storageType) throws IOException {
        OExistsDatabaseRequest request = new OExistsDatabaseRequest(iDatabaseName, storageType);
        OExistsDatabaseResponse response = this.networkAdminOperation(request, "Error on checking existence of the remote storage: " + this.storage.getName());
        return response.isExists();
    }

    public synchronized boolean existsDatabase(String storageType) throws IOException {
        return this.existsDatabase(this.storage.getName(), storageType);
    }

    @Deprecated
    public OServerAdmin deleteDatabase(String storageType) throws IOException {
        return this.dropDatabase(storageType);
    }

    public synchronized OServerAdmin dropDatabase(String iDatabaseName, String storageType) throws IOException {
        ODropDatabaseRequest request = new ODropDatabaseRequest(iDatabaseName, storageType);
        ODropDatabaseResponse response = this.networkAdminOperation(request, "Cannot delete the remote storage: " + this.storage.getName());
        OURLConnection connection = OURLHelper.parse((String)this.getURL());
        OrientDBRemote remote = (OrientDBRemote)ODatabaseDocumentTxInternal.getOrCreateRemoteFactory((String)connection.getPath());
        remote.forceDatabaseClose(iDatabaseName);
        ODatabaseRecordThreadLocal.instance().remove();
        return this;
    }

    public synchronized OServerAdmin dropDatabase(String storageType) throws IOException {
        return this.dropDatabase(this.storage.getName(), storageType);
    }

    public synchronized OServerAdmin freezeDatabase(String storageType) throws IOException {
        OFreezeDatabaseRequest request = new OFreezeDatabaseRequest(this.storage.getName(), storageType);
        OFreezeDatabaseResponse response = this.networkAdminOperation(request, "Cannot freeze the remote storage: " + this.storage.getName());
        return this;
    }

    public synchronized OServerAdmin releaseDatabase(String storageType) throws IOException {
        OReleaseDatabaseRequest request = new OReleaseDatabaseRequest(this.storage.getName(), storageType);
        OReleaseDatabaseResponse response = this.networkAdminOperation(request, "Cannot release the remote storage: " + this.storage.getName());
        return this;
    }

    public ODocument clusterStatus() {
        ODistributedStatusRequest request = new ODistributedStatusRequest();
        ODistributedStatusResponse response = this.storage.networkOperation(request, "Error on executing Cluster status ");
        OLogManager.instance().debug((Object)this, "Cluster status %s", new Object[]{response.getClusterConfig().toJSON("prettyPrint")});
        return response.getClusterConfig();
    }

    public synchronized Map<String, String> getGlobalConfigurations() throws IOException {
        OListGlobalConfigurationsRequest request = new OListGlobalConfigurationsRequest();
        OListGlobalConfigurationsResponse response = this.networkAdminOperation(request, "Cannot retrieve the configuration list");
        return response.getConfigs();
    }

    public synchronized String getGlobalConfiguration(OGlobalConfiguration config) throws IOException {
        OGetGlobalConfigurationRequest request = new OGetGlobalConfigurationRequest(config.getKey());
        OGetGlobalConfigurationResponse response = this.networkAdminOperation(request, "Cannot retrieve the configuration value: " + config.getKey());
        return response.getValue();
    }

    public synchronized OServerAdmin setGlobalConfiguration(OGlobalConfiguration config, Object iValue) throws IOException {
        OSetGlobalConfigurationRequest request = new OSetGlobalConfigurationRequest(config.getKey(), iValue != null ? iValue.toString() : "");
        OSetGlobalConfigurationResponse response = this.networkAdminOperation(request, "Cannot set the configuration value: " + config.getKey());
        return this;
    }

    public synchronized void close() {
        this.storage.close();
    }

    public synchronized void close(boolean iForce) {
        this.storage.close(iForce, false);
    }

    public synchronized String getURL() {
        return this.storage != null ? this.storage.getURL() : null;
    }

    public boolean isConnected() {
        return this.storage != null && !this.storage.isClosed();
    }

    protected <T extends OBinaryResponse> T networkAdminOperation(final OBinaryRequest<T> request, String errorMessage) {
        return (T)((OBinaryResponse)this.networkAdminOperation(new OStorageRemoteOperation<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T execute(OChannelBinaryAsynchClient network, OStorageRemoteSession session) throws IOException {
                try {
                    network.beginRequest(request.getCommand(), session);
                    request.write((OChannelDataOutput)network, session);
                }
                finally {
                    network.endRequest();
                }
                Object response = request.createResponse();
                try {
                    OServerAdmin.this.storage.beginResponse(network, session);
                    response.read((OChannelDataInput)network, session);
                }
                finally {
                    OServerAdmin.this.storage.endResponse(network);
                }
                return response;
            }
        }, errorMessage));
    }

    protected <T> T networkAdminOperation(OStorageRemoteOperation<T> operation, String errorMessage) {
        OChannelBinaryAsynchClient network = null;
        try {
            String serverUrl = this.storage.getNextAvailableServerURL(false, this.session);
            do {
                try {
                    network = this.storage.getNetwork(serverUrl);
                }
                catch (OException e) {
                    serverUrl = this.storage.useNewServerURL(serverUrl);
                    if (serverUrl != null) continue;
                    throw e;
                }
            } while (network == null);
            T res = operation.execute(network, this.storage.getCurrentSession());
            this.storage.connectionManager.release(network);
            return res;
        }
        catch (Exception e) {
            if (network != null) {
                this.storage.connectionManager.release(network);
            }
            this.storage.close(true, false);
            throw OException.wrapException((OException)new OStorageException(errorMessage), (Throwable)e);
        }
    }
}

