/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.text.TextUtils;
import android.util.Log;
import com.orhanobut.logger.LogLevel;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.Printer;
import com.orhanobut.logger.Settings;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class LoggerPrinter
implements Printer {
    private static final int CHUNK_SIZE = 4000;
    private static final int JSON_INDENT = 4;
    private static final int MIN_STACK_OFFSET = 3;
    private static final Settings settings = new Settings();
    private static final char TOP_LEFT_CORNER = '\u2554';
    private static final char BOTTOM_LEFT_CORNER = '\u255a';
    private static final char MIDDLE_CORNER = '\u255f';
    private static final char HORIZONTAL_DOUBLE_LINE = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static String TAG = "PRETTYLOGGER";
    private static final ThreadLocal<String> LOCAL_TAG = new ThreadLocal();
    private static final ThreadLocal<Integer> LOCAL_METHOD_COUNT = new ThreadLocal();

    LoggerPrinter() {
    }

    @Override
    public Settings init(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag may not be null");
        }
        if (tag.trim().length() == 0) {
            throw new IllegalStateException("tag may not be empty");
        }
        TAG = tag;
        return settings;
    }

    @Override
    public Printer t(String tag, int methodCount) {
        if (tag != null) {
            LOCAL_TAG.set(tag);
        }
        LOCAL_METHOD_COUNT.set(methodCount);
        return this;
    }

    @Override
    public void d(String message, Object ... args) {
        this.log(3, message, args);
    }

    @Override
    public void e(String message, Object ... args) {
        this.e(null, message, args);
    }

    @Override
    public void e(Throwable throwable, String message, Object ... args) {
        if (throwable != null && message != null) {
            message = message + " : " + throwable.toString();
        }
        if (throwable != null && message == null) {
            message = throwable.toString();
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        this.log(6, message, args);
    }

    @Override
    public void i(String message, Object ... args) {
        this.log(4, message, args);
    }

    @Override
    public void v(String message, Object ... args) {
        this.log(2, message, args);
    }

    @Override
    public void wtf(String message, Object ... args) {
        this.log(7, message, args);
    }

    @Override
    public void json(String json) {
        String tag = this.getTag();
        int methodCount = this.getMethodCount();
        if (TextUtils.isEmpty((CharSequence)json)) {
            this.d(tag, "Empty/Null json content", methodCount);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                this.d(tag, message, methodCount);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                this.d(tag, message, methodCount);
            }
        }
        catch (JSONException e) {
            this.d(tag, e.getCause().getMessage() + "\n" + json, methodCount);
        }
    }

    @Override
    public void xml(String xml) {
        String tag = this.getTag();
        int methodCount = this.getMethodCount();
        if (TextUtils.isEmpty((CharSequence)xml)) {
            this.d(tag, "Empty/Null xml content", methodCount);
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            this.d(tag, xmlOutput.getWriter().toString().replaceFirst(">", ">\n"), methodCount);
        }
        catch (TransformerException e) {
            this.d(tag, e.getCause().getMessage() + "\n" + xml, methodCount);
        }
    }

    private synchronized void log(int logType, String msg, Object ... args) {
        if (settings.getLogLevel() == LogLevel.NONE) {
            return;
        }
        String tag = this.getTag();
        String message = this.createMessage(msg, args);
        int methodCount = this.getMethodCount();
        this.logTopBorder(logType, tag);
        this.logHeaderContent(logType, tag, methodCount);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            if (methodCount > 0) {
                this.logDivider(logType, tag);
            }
            this.logContent(logType, tag, message);
            this.logBottomBorder(logType, tag);
            return;
        }
        if (methodCount > 0) {
            this.logDivider(logType, tag);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            this.logContent(logType, tag, new String(bytes, i, count));
        }
        this.logBottomBorder(logType, tag);
    }

    private void logTopBorder(int logType, String tag) {
        this.logChunk(logType, tag, TOP_BORDER);
    }

    private void logHeaderContent(int logType, String tag, int methodCount) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (settings.isShowThreadInfo()) {
            this.logChunk(logType, tag, "\u2551 Thread: " + Thread.currentThread().getName());
            this.logDivider(logType, tag);
        }
        String level = "";
        int stackOffset = this.getStackOffset(trace);
        if (methodCount + stackOffset > trace.length) {
            methodCount = trace.length - stackOffset - 1;
        }
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + stackOffset;
            StringBuilder builder = new StringBuilder();
            builder.append("\u2551 ").append(level).append(this.getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
            level = level + "   ";
            this.logChunk(logType, tag, builder.toString());
        }
    }

    private void logBottomBorder(int logType, String tag) {
        this.logChunk(logType, tag, BOTTOM_BORDER);
    }

    private void logDivider(int logType, String tag) {
        this.logChunk(logType, tag, MIDDLE_BORDER);
    }

    private void logContent(int logType, String tag, String chunk) {
        String[] lines;
        for (String line : lines = chunk.split(System.getProperty("line.separator"))) {
            this.logChunk(logType, tag, "\u2551 " + line);
        }
    }

    private void logChunk(int logType, String tag, String chunk) {
        String finalTag = this.formatTag(tag);
        switch (logType) {
            case 6: {
                Log.e((String)finalTag, (String)chunk);
                break;
            }
            case 4: {
                Log.i((String)finalTag, (String)chunk);
                break;
            }
            case 2: {
                Log.v((String)finalTag, (String)chunk);
                break;
            }
            case 5: {
                Log.w((String)finalTag, (String)chunk);
                break;
            }
            case 7: {
                Log.wtf((String)finalTag, (String)chunk);
                break;
            }
            default: {
                Log.d((String)finalTag, (String)chunk);
            }
        }
    }

    private String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }

    private String formatTag(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag) && !TextUtils.equals((CharSequence)TAG, (CharSequence)tag)) {
            return TAG + "-" + tag;
        }
        return TAG;
    }

    private String getTag() {
        String tag = LOCAL_TAG.get();
        if (tag != null) {
            LOCAL_TAG.remove();
            return tag;
        }
        return TAG;
    }

    private String createMessage(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    private int getMethodCount() {
        Integer count = LOCAL_METHOD_COUNT.get();
        int result = settings.getMethodCount();
        if (count != null) {
            LOCAL_METHOD_COUNT.remove();
            result = count;
        }
        if (result < 0) {
            throw new IllegalStateException("methodCount cannot be negative");
        }
        return result;
    }

    private int getStackOffset(StackTraceElement[] trace) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(LoggerPrinter.class.getName()) || name.equals(Logger.class.getName())) continue;
            return --i;
        }
        return -1;
    }
}

