/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.content.SharedPreferences;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.Storage;

final class SharedPreferencesStorage
implements Storage {
    private final SharedPreferences preferences;

    SharedPreferencesStorage(Context context, String tag) {
        this.preferences = context.getSharedPreferences(tag, 0);
    }

    SharedPreferencesStorage(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public <T> boolean put(String key, T value) {
        HawkUtils.checkNull("key", key);
        return this.getEditor().putString(key, String.valueOf(value)).commit();
    }

    @Override
    public <T> T get(String key) {
        return (T)this.preferences.getString(key, null);
    }

    @Override
    public boolean delete(String key) {
        return this.getEditor().remove(key).commit();
    }

    @Override
    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    @Override
    public boolean deleteAll() {
        return this.getEditor().clear().commit();
    }

    @Override
    public long count() {
        return this.preferences.getAll().size();
    }

    private SharedPreferences.Editor getEditor() {
        return this.preferences.edit();
    }
}

