/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.google.gson.reflect.TypeToken;
import com.orhanobut.hawk.Converter;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.Parser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class HawkConverter
implements Converter {
    private final Parser parser;

    public HawkConverter(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser should not be null");
        }
        this.parser = parser;
    }

    @Override
    public <T> String toString(T value) {
        if (value == null) {
            return null;
        }
        return this.parser.toJson(value);
    }

    @Override
    public <T> T fromString(String value, DataInfo info) throws Exception {
        if (value == null) {
            return null;
        }
        HawkUtils.checkNull("data info", info);
        Class keyType = info.keyClazz;
        Class valueType = info.valueClazz;
        switch (info.dataType) {
            case '0': {
                return this.toObject(value, keyType);
            }
            case '1': {
                return this.toList(value, keyType);
            }
            case '2': {
                return this.toMap(value, keyType, valueType);
            }
            case '3': {
                return this.toSet(value, keyType);
            }
        }
        return null;
    }

    private <T> T toObject(String json, Class<?> type) throws Exception {
        return this.parser.fromJson(json, type);
    }

    private <T> T toList(String json, Class<?> type) throws Exception {
        if (type == null) {
            return (T)new ArrayList();
        }
        List list = (List)this.parser.fromJson(json, new TypeToken<List<T>>(){}.getType());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, this.parser.fromJson(this.parser.toJson(list.get(i)), type));
        }
        return (T)list;
    }

    private <T> T toSet(String json, Class<?> type) throws Exception {
        HashSet resultSet = new HashSet();
        if (type == null) {
            return (T)resultSet;
        }
        Set set = (Set)this.parser.fromJson(json, new TypeToken<Set<T>>(){}.getType());
        for (Object t : set) {
            String valueJson = this.parser.toJson(t);
            Object value = this.parser.fromJson(valueJson, type);
            resultSet.add(value);
        }
        return (T)resultSet;
    }

    private <K, V, T> T toMap(String json, Class<?> keyType, Class<?> valueType) throws Exception {
        HashMap resultMap = new HashMap();
        if (keyType == null || valueType == null) {
            return (T)resultMap;
        }
        Map map = (Map)this.parser.fromJson(json, new TypeToken<Map<K, V>>(){}.getType());
        for (Map.Entry entry : map.entrySet()) {
            String keyJson = this.parser.toJson(entry.getKey());
            Object k = this.parser.fromJson(keyJson, keyType);
            String valueJson = this.parser.toJson(entry.getValue());
            Object v = this.parser.fromJson(valueJson, valueType);
            resultMap.put(k, v);
        }
        return (T)resultMap;
    }
}

