/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.orhanobut.dialogplus.HolderAdapter;
import com.orhanobut.dialogplus.OnHolderListener;
import com.orhanobut.dialogplus.R;

public class ListHolder
implements HolderAdapter,
AdapterView.OnItemClickListener {
    private static final String TAG = ListHolder.class.getSimpleName();
    private int backgroundColor;
    private ListView listView;
    private OnHolderListener listener;
    private View.OnKeyListener keyListener;

    @Override
    public void addHeader(View view) {
        if (view == null) {
            return;
        }
        this.listView.addHeaderView(view);
    }

    @Override
    public void addFooter(View view) {
        if (view == null) {
            return;
        }
        this.listView.addFooterView(view);
    }

    @Override
    public void setAdapter(BaseAdapter adapter) {
        this.listView.setAdapter((ListAdapter)adapter);
    }

    @Override
    public void setBackgroundColor(int colorResource) {
        this.backgroundColor = colorResource;
    }

    @Override
    public View getView(LayoutInflater inflater, ViewGroup parent) {
        View view = inflater.inflate(R.layout.dialog_list, parent, false);
        this.listView = (ListView)view.findViewById(R.id.list);
        this.listView.setBackgroundColor(parent.getResources().getColor(this.backgroundColor));
        this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.listView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (ListHolder.this.keyListener == null) {
                    throw new NullPointerException("keyListener should not be null");
                }
                return ListHolder.this.keyListener.onKey(v, keyCode, event);
            }
        });
        return view;
    }

    @Override
    public void setOnItemClickListener(OnHolderListener listener) {
        this.listener = listener;
    }

    @Override
    public void setOnKeyListener(View.OnKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    @Override
    public View getInflatedView() {
        return this.listView;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.listener.onItemClick(parent.getItemAtPosition(position), view, position);
    }
}

