/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.dialogplus;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.widget.AbsListView;
import com.orhanobut.dialogplus.HeightAnimation;
import com.orhanobut.dialogplus.R;

final class Utils {
    private static final int INVALID = -1;

    private Utils() {
    }

    static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    static void animateContent(View view, int to, Animation.AnimationListener listener) {
        HeightAnimation animation = new HeightAnimation(view, view.getHeight(), to);
        animation.setAnimationListener(listener);
        animation.setDuration(200L);
        view.startAnimation((Animation)animation);
    }

    static boolean listIsAtTop(AbsListView listView) {
        return listView.getChildCount() == 0 || listView.getChildAt(0).getTop() == listView.getPaddingTop();
    }

    static View getView(Context context, int resourceId, View view) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (view != null) {
            return view;
        }
        if (resourceId != -1) {
            view = inflater.inflate(resourceId, null);
        }
        return view;
    }

    static int getAnimationResource(int gravity, boolean isInAnimation) {
        switch (gravity) {
            case 48: {
                return isInAnimation ? R.anim.slide_in_top : R.anim.slide_out_top;
            }
            case 80: {
                return isInAnimation ? R.anim.slide_in_bottom : R.anim.slide_out_bottom;
            }
            case 17: {
                return isInAnimation ? R.anim.fade_in_center : R.anim.fade_out_center;
            }
        }
        return -1;
    }
}

