/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.util.UnsignedLongDeserializer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableValue
extends Value {
    private final long createIndex;
    private final long modifyIndex;
    private final long lockIndex;
    private final String key;
    private final long flags;
    @Nullable
    private final String value;
    @Nullable
    private final String session;
    private volatile long lazyInitBitmap;
    private static final long VALUE_AS_STRING_LAZY_INIT_BIT = 1L;
    private Optional<String> valueAsString;
    private static final long VALUE_AS_BYTES_LAZY_INIT_BIT = 2L;
    private Optional<byte[]> valueAsBytes;

    private ImmutableValue(long createIndex, long modifyIndex, long lockIndex, String key, long flags, @Nullable String value, @Nullable String session) {
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
        this.lockIndex = lockIndex;
        this.key = key;
        this.flags = flags;
        this.value = value;
        this.session = session;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public long getCreateIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public long getModifyIndex() {
        return this.modifyIndex;
    }

    @Override
    @JsonProperty(value="LockIndex")
    public long getLockIndex() {
        return this.lockIndex;
    }

    @Override
    @JsonProperty(value="Key")
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="Flags")
    @JsonDeserialize(using=UnsignedLongDeserializer.class)
    public long getFlags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Value")
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> getSession() {
        return Optional.ofNullable(this.session);
    }

    public final ImmutableValue withCreateIndex(long value) {
        if (this.createIndex == value) {
            return this;
        }
        return new ImmutableValue(value, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, this.session);
    }

    public final ImmutableValue withModifyIndex(long value) {
        if (this.modifyIndex == value) {
            return this;
        }
        return new ImmutableValue(this.createIndex, value, this.lockIndex, this.key, this.flags, this.value, this.session);
    }

    public final ImmutableValue withLockIndex(long value) {
        if (this.lockIndex == value) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, value, this.key, this.flags, this.value, this.session);
    }

    public final ImmutableValue withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, (String)Preconditions.checkNotNull((Object)value, (Object)"key"), this.flags, this.value, this.session);
    }

    public final ImmutableValue withFlags(long value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, value, this.value, this.session);
    }

    public final ImmutableValue withValue(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, newValue, this.session);
    }

    public final ImmutableValue withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, value, this.session);
    }

    public final ImmutableValue withSession(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"session");
        if (Objects.equals(this.session, newValue)) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, newValue);
    }

    public final ImmutableValue withSession(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.session, value)) {
            return this;
        }
        return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValue && this.equalTo((ImmutableValue)another);
    }

    private boolean equalTo(ImmutableValue another) {
        return this.createIndex == another.createIndex && this.modifyIndex == another.modifyIndex && this.lockIndex == another.lockIndex && this.key.equals(another.key) && this.flags == another.flags && Objects.equals(this.value, another.value) && Objects.equals(this.session, another.session);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.createIndex);
        h = h * 17 + Longs.hashCode((long)this.modifyIndex);
        h = h * 17 + Longs.hashCode((long)this.lockIndex);
        h = h * 17 + this.key.hashCode();
        h = h * 17 + Longs.hashCode((long)this.flags);
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.value});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.session});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Value").omitNullValues().add("createIndex", this.createIndex).add("modifyIndex", this.modifyIndex).add("lockIndex", this.lockIndex).add("key", (Object)this.key).add("flags", this.flags).add("value", (Object)this.value).add("session", (Object)this.session).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableValue fromJson(Json json) {
        Builder builder = ImmutableValue.builder();
        if (json.createIndex != null) {
            builder.createIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.modifyIndex(json.modifyIndex);
        }
        if (json.lockIndex != null) {
            builder.lockIndex(json.lockIndex);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getValueAsString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableValue immutableValue = this;
            synchronized (immutableValue) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.valueAsString = (Optional)Preconditions.checkNotNull(super.getValueAsString(), (Object)"valueAsString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.valueAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<byte[]> getValueAsBytes() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableValue immutableValue = this;
            synchronized (immutableValue) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.valueAsBytes = (Optional)Preconditions.checkNotNull(super.getValueAsBytes(), (Object)"valueAsBytes");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.valueAsBytes;
    }

    public static ImmutableValue copyOf(Value instance) {
        if (instance instanceof ImmutableValue) {
            return (ImmutableValue)instance;
        }
        return ImmutableValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATE_INDEX = 1L;
        private static final long INIT_BIT_MODIFY_INDEX = 2L;
        private static final long INIT_BIT_LOCK_INDEX = 4L;
        private static final long INIT_BIT_KEY = 8L;
        private static final long INIT_BIT_FLAGS = 16L;
        private long initBits = 31L;
        private long createIndex;
        private long modifyIndex;
        private long lockIndex;
        @Nullable
        private String key;
        private long flags;
        @Nullable
        private String value;
        @Nullable
        private String session;

        private Builder() {
        }

        public final Builder from(Value instance) {
            Optional<String> sessionOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.createIndex(instance.getCreateIndex());
            this.modifyIndex(instance.getModifyIndex());
            this.lockIndex(instance.getLockIndex());
            this.key(instance.getKey());
            this.flags(instance.getFlags());
            Optional<String> valueOptional = instance.getValue();
            if (valueOptional.isPresent()) {
                this.value(valueOptional);
            }
            if ((sessionOptional = instance.getSession()).isPresent()) {
                this.session(sessionOptional);
            }
            return this;
        }

        public final Builder createIndex(long createIndex) {
            this.createIndex = createIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder modifyIndex(long modifyIndex) {
            this.modifyIndex = modifyIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lockIndex(long lockIndex) {
            this.lockIndex = lockIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder flags(long flags) {
            this.flags = flags;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder value(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        public final Builder value(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder session(String session) {
            this.session = (String)Preconditions.checkNotNull((Object)session, (Object)"session");
            return this;
        }

        public final Builder session(Optional<String> session) {
            this.session = session.orElse(null);
            return this;
        }

        public ImmutableValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValue(this.createIndex, this.modifyIndex, this.lockIndex, this.key, this.flags, this.value, this.session);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modifyIndex");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lockIndex");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("flags");
            }
            return "Cannot build Value, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Value {
        @Nullable
        Long createIndex;
        @Nullable
        Long modifyIndex;
        @Nullable
        Long lockIndex;
        @Nullable
        String key;
        @Nullable
        Long flags;
        Optional<String> value = Optional.empty();
        Optional<String> session = Optional.empty();

        Json() {
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(long createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(long modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @JsonProperty(value="LockIndex")
        public void setLockIndex(long lockIndex) {
            this.lockIndex = lockIndex;
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="Flags")
        @JsonDeserialize(using=UnsignedLongDeserializer.class)
        public void setFlags(long flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Value")
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this.session = session;
        }

        @Override
        public long getCreateIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getModifyIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLockIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getFlags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValueAsString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getValueAsBytes() {
            throw new UnsupportedOperationException();
        }
    }
}

