/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.kv.TxError;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTxError
extends TxError {
    @Nullable
    private final BigInteger opIndex;
    @Nullable
    private final String what;

    private ImmutableTxError(@Nullable BigInteger opIndex, @Nullable String what) {
        this.opIndex = opIndex;
        this.what = what;
    }

    @Override
    @JsonProperty(value="OpIndex")
    public Optional<BigInteger> opIndex() {
        return Optional.ofNullable(this.opIndex);
    }

    @Override
    @JsonProperty(value="What")
    public Optional<String> what() {
        return Optional.ofNullable(this.what);
    }

    public final ImmutableTxError withOpIndex(BigInteger value) {
        BigInteger newValue = (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"opIndex");
        if (this.opIndex == newValue) {
            return this;
        }
        return new ImmutableTxError(newValue, this.what);
    }

    public final ImmutableTxError withOpIndex(Optional<BigInteger> optional) {
        BigInteger value = optional.orElse(null);
        if (this.opIndex == value) {
            return this;
        }
        return new ImmutableTxError(value, this.what);
    }

    public final ImmutableTxError withWhat(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"what");
        if (Objects.equals(this.what, newValue)) {
            return this;
        }
        return new ImmutableTxError(this.opIndex, newValue);
    }

    public final ImmutableTxError withWhat(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.what, value)) {
            return this;
        }
        return new ImmutableTxError(this.opIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTxError && this.equalTo((ImmutableTxError)another);
    }

    private boolean equalTo(ImmutableTxError another) {
        return Objects.equals(this.opIndex, another.opIndex) && Objects.equals(this.what, another.what);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.opIndex});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.what});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TxError").omitNullValues().add("opIndex", (Object)this.opIndex).add("what", (Object)this.what).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTxError fromJson(Json json) {
        Builder builder = ImmutableTxError.builder();
        if (json.opIndex != null) {
            builder.opIndex(json.opIndex);
        }
        if (json.what != null) {
            builder.what(json.what);
        }
        return builder.build();
    }

    public static ImmutableTxError copyOf(TxError instance) {
        if (instance instanceof ImmutableTxError) {
            return (ImmutableTxError)instance;
        }
        return ImmutableTxError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private BigInteger opIndex;
        @Nullable
        private String what;

        private Builder() {
        }

        public final Builder from(TxError instance) {
            Optional<String> whatOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<BigInteger> opIndexOptional = instance.opIndex();
            if (opIndexOptional.isPresent()) {
                this.opIndex(opIndexOptional);
            }
            if ((whatOptional = instance.what()).isPresent()) {
                this.what(whatOptional);
            }
            return this;
        }

        public final Builder opIndex(BigInteger opIndex) {
            this.opIndex = (BigInteger)Preconditions.checkNotNull((Object)opIndex, (Object)"opIndex");
            return this;
        }

        public final Builder opIndex(Optional<BigInteger> opIndex) {
            this.opIndex = opIndex.orElse(null);
            return this;
        }

        public final Builder what(String what) {
            this.what = (String)Preconditions.checkNotNull((Object)what, (Object)"what");
            return this;
        }

        public final Builder what(Optional<String> what) {
            this.what = what.orElse(null);
            return this;
        }

        public ImmutableTxError build() {
            return new ImmutableTxError(this.opIndex, this.what);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends TxError {
        Optional<BigInteger> opIndex = Optional.empty();
        Optional<String> what = Optional.empty();

        Json() {
        }

        @JsonProperty(value="OpIndex")
        public void setOpIndex(Optional<BigInteger> opIndex) {
            this.opIndex = opIndex;
        }

        @JsonProperty(value="What")
        public void setWhat(Optional<String> what) {
            this.what = what;
        }

        @Override
        public Optional<BigInteger> opIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> what() {
            throw new UnsupportedOperationException();
        }
    }
}

