/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import redis.netty4.AbstarctReply;
import redis.util.Encoding;

public class IntegerReply
extends AbstarctReply<Long> {
    public static final char MARKER = ':';
    private static IntegerReply[] replies = new IntegerReply[512];

    public static IntegerReply integer(long integer) {
        if (integer > -256L && integer < 256L) {
            return replies[(int)(integer + 255L)];
        }
        return new IntegerReply(integer);
    }

    public IntegerReply(long integer) {
        super(integer);
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(58);
        os.writeBytes(Encoding.numToBytes((Long)this.data(), true));
    }

    public String toString() {
        return ((Long)this.data()).toString();
    }

    static {
        for (int i = -255; i < 256; ++i) {
            IntegerReply.replies[i + 255] = new IntegerReply(i);
        }
    }
}

