/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import redis.netty4.AbstarctReply;
import redis.util.Encoding;

public class BulkReply
extends AbstarctReply<ByteBuf> {
    public static final BulkReply NIL_REPLY = new BulkReply();
    public static final char MARKER = '$';
    private final int capacity;

    private BulkReply() {
        super(null);
        this.capacity = -1;
    }

    public BulkReply(byte[] bytes) {
        super(Unpooled.wrappedBuffer(bytes));
        this.capacity = bytes.length;
    }

    public BulkReply(ByteBuf bytes) {
        super(bytes);
        bytes.retain();
        this.capacity = bytes.capacity();
    }

    public String asAsciiString() {
        if (this.data() == null) {
            return null;
        }
        return ((ByteBuf)this.data()).toString(CharsetUtil.US_ASCII);
    }

    public String asUTF8String() {
        if (this.data() == null) {
            return null;
        }
        return ((ByteBuf)this.data()).toString(CharsetUtil.UTF_8);
    }

    public byte[] asByteArray() {
        if (this.data() == null) {
            return null;
        }
        byte[] res = new byte[((ByteBuf)this.data()).readableBytes()];
        ((ByteBuf)this.data()).getBytes(((ByteBuf)this.data()).readerIndex(), res);
        return res;
    }

    public String asString(Charset charset) {
        if (this.data() == null) {
            return null;
        }
        return ((ByteBuf)this.data()).toString(charset);
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(36);
        os.writeBytes(Encoding.numToBytes(this.capacity, true));
        if (this.capacity > 0) {
            os.writeBytes((ByteBuf)this.data());
            os.writeBytes(CRLF);
        }
    }

    public String toString() {
        return this.asUTF8String();
    }

    @Override
    public void releaseAll() {
        ((ByteBuf)this.data()).release();
    }
}

