/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ReflectionDataBuilder
implements RuntimeReflectionSupport {
    private static final EnumSet<FieldFlag> NO_FIELD_FLAGS = EnumSet.noneOf(FieldFlag.class);
    private boolean modified;
    private boolean sealed;
    private final DynamicHub.ReflectionData arrayReflectionData;
    private Set<Class<?>> reflectionClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Executable> reflectionMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<Field, EnumSet<FieldFlag>> reflectionFields = new ConcurrentHashMap<Field, EnumSet<FieldFlag>>();
    private Set<Field> analyzedFinalFields = Collections.newSetFromMap(new ConcurrentHashMap());

    public ReflectionDataBuilder() {
        this.arrayReflectionData = ReflectionDataBuilder.getArrayReflectionData();
    }

    private static DynamicHub.ReflectionData getArrayReflectionData() {
        Method[] publicArrayMethods;
        try {
            Class[] parameterTypes = new Class[]{};
            Method getPublicMethodsMethod = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetPublicMethods", (Class[])parameterTypes);
            publicArrayMethods = (Method[])getPublicMethodsMethod.invoke(Object[].class, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        return new DynamicHub.ReflectionData(new Field[0], new Field[0], new Field[0], new Method[0], publicArrayMethods, new Constructor[0], new Constructor[0], null, new Field[0], new Method[0], new Class[0], new Class[0], null);
    }

    public void register(Class<?> ... classes) {
        this.checkNotSealed();
        if (this.reflectionClasses.addAll(Arrays.asList(classes))) {
            this.modified = true;
        }
    }

    public void register(Executable ... methods) {
        this.checkNotSealed();
        if (this.reflectionMethods.addAll(Arrays.asList(methods))) {
            this.modified = true;
        }
    }

    public void register(boolean finalIsWritable, boolean allowUnsafeAccess, Field ... fields) {
        this.checkNotSealed();
        for (Field field : fields) {
            boolean writable;
            boolean bl = writable = finalIsWritable || !Modifier.isFinal(field.getModifiers());
            EnumSet<FieldFlag> flags = writable && allowUnsafeAccess ? EnumSet.of(FieldFlag.FINAL_BUT_WRITABLE, FieldFlag.UNSAFE_ACCESSIBLE) : (writable ? EnumSet.of(FieldFlag.FINAL_BUT_WRITABLE) : (allowUnsafeAccess ? EnumSet.of(FieldFlag.UNSAFE_ACCESSIBLE) : NO_FIELD_FLAGS));
            this.reflectionFields.compute(field, (key, existingFlags) -> {
                if (writable && (existingFlags == null || !existingFlags.contains((Object)FieldFlag.FINAL_BUT_WRITABLE))) {
                    UserError.guarantee(!this.analyzedFinalFields.contains(field), "A field that was already processed by the analysis cannot be re-registered as writable: " + field.toString(), new Object[0]);
                }
                return flags;
            });
        }
    }

    private void checkNotSealed() {
        if (this.sealed) {
            throw UserError.abort("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finised.");
        }
    }

    protected void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!this.modified) {
            return;
        }
        this.modified = false;
        access.requireAnalysisIteration();
        Class[] parameterTypes = new Class[]{};
        Method reflectionDataMethod = ReflectionUtil.lookupMethod(Class.class, (String)"reflectionData", (Class[])parameterTypes);
        Class<?> originalReflectionDataClass = access.getImageClassLoader().findClassByName("java.lang.Class$ReflectionData");
        Field declaredFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredFields");
        Field publicFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicFields");
        Field declaredMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredMethods");
        Field publicMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicMethods");
        Field declaredConstructorsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredConstructors");
        Field publicConstructorsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicConstructors");
        Field declaredPublicFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredPublicFields");
        Field declaredPublicMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredPublicMethods");
        HashSet allClasses = new HashSet(this.reflectionClasses);
        this.reflectionMethods.stream().map(Executable::getDeclaringClass).forEach(allClasses::add);
        this.reflectionFields.forEach((field, flags) -> {
            if (flags.contains((Object)FieldFlag.UNSAFE_ACCESSIBLE)) {
                access.registerAsUnsafeAccessed((Field)field);
            }
            allClasses.add(field.getDeclaringClass());
        });
        for (AnalysisType analysisType : access.getUniverse().getTypes()) {
            Class originalClass = analysisType.getJavaClass();
            if (originalClass != null && this.enclosingMethodOrConstructor(originalClass) != null) {
                allClasses.add(originalClass);
                continue;
            }
            if (originalClass == null || !originalClass.isArray()) continue;
            allClasses.add(originalClass);
        }
        for (Class clazz : allClasses) {
            AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
            DynamicHub hub = access.getHostVM().dynamicHub((ResolvedJavaType)type);
            if (type.isArray()) {
                type.registerAsInHeap();
            }
            if (this.reflectionClasses.contains(clazz)) {
                ClassForNameSupport.registerClass(clazz);
            }
            try {
                clazz.getDeclaredFields();
                clazz.getFields();
                clazz.getDeclaredMethods();
                clazz.getMethods();
                clazz.getDeclaredConstructors();
                clazz.getConstructors();
                clazz.getDeclaredClasses();
                clazz.getClasses();
            }
            catch (NoClassDefFoundError e) {
                System.out.println("WARNING: Could not register reflection metadata for " + clazz.getTypeName() + ". Reason: " + e.getClass().getTypeName() + ": " + e.getMessage() + ".");
                continue;
            }
            try {
                Object originalReflectionData = reflectionDataMethod.invoke((Object)clazz, new Object[0]);
                DynamicHub.ReflectionData reflectionData = type.isArray() ? this.arrayReflectionData : new DynamicHub.ReflectionData(ReflectionDataBuilder.filterFields(declaredFieldsField.get(originalReflectionData), this.reflectionFields.keySet(), access.getMetaAccess()), ReflectionDataBuilder.filterFields(publicFieldsField.get(originalReflectionData), this.reflectionFields.keySet(), access.getMetaAccess()), ReflectionDataBuilder.filterFields(publicFieldsField.get(originalReflectionData), (Field f) -> this.reflectionFields.containsKey(f) && !ReflectionDataBuilder.isHiddenIn(f, clazz), access.getMetaAccess()), ReflectionDataBuilder.filterMethods(declaredMethodsField.get(originalReflectionData), this.reflectionMethods, access.getMetaAccess()), ReflectionDataBuilder.filterMethods(publicMethodsField.get(originalReflectionData), this.reflectionMethods, access.getMetaAccess()), ReflectionDataBuilder.filterConstructors(declaredConstructorsField.get(originalReflectionData), this.reflectionMethods, access.getMetaAccess()), ReflectionDataBuilder.filterConstructors(publicConstructorsField.get(originalReflectionData), this.reflectionMethods, access.getMetaAccess()), ReflectionDataBuilder.nullaryConstructor(declaredConstructorsField.get(originalReflectionData), this.reflectionMethods), ReflectionDataBuilder.filterFields(declaredPublicFieldsField.get(originalReflectionData), this.reflectionFields.keySet(), access.getMetaAccess()), ReflectionDataBuilder.filterMethods(declaredPublicMethodsField.get(originalReflectionData), this.reflectionMethods, access.getMetaAccess()), ReflectionDataBuilder.filterClasses(clazz.getDeclaredClasses(), this.reflectionClasses, access.getMetaAccess()), ReflectionDataBuilder.filterClasses(clazz.getClasses(), this.reflectionClasses, access.getMetaAccess()), this.enclosingMethodOrConstructor(clazz));
                hub.setReflectionData(reflectionData);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    protected void afterAnalysis() {
        this.sealed = true;
        if (this.modified) {
            throw UserError.abort("Registration of classes, methods, and fields for reflective access during analysis must set DuringAnalysisAccess.requireAnalysisIteration().");
        }
    }

    private static Constructor<?> nullaryConstructor(Object constructors, Set<?> reflectionMethods) {
        for (Constructor constructor : (Constructor[])constructors) {
            if (constructor.getParameterCount() != 0 || !reflectionMethods.contains(constructor)) continue;
            return constructor;
        }
        return null;
    }

    private Executable enclosingMethodOrConstructor(Class<?> clazz) {
        Executable enclosingMethodOrConstructor;
        Constructor<?> enclosingConstructor;
        Method enclosingMethod;
        try {
            enclosingMethod = clazz.getEnclosingMethod();
            enclosingConstructor = clazz.getEnclosingConstructor();
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (InternalError ex) {
            System.err.println("GR-7731: Could not find the enclosing method of class " + clazz.getTypeName() + ". This is a known transient error and most likely does not cause any problems, unless your code relies on the enclosing method of exactly this class. If you can reliably reproduce this problem, please send us a test case.");
            return null;
        }
        if (enclosingMethod == null && enclosingConstructor == null) {
            return null;
        }
        if (enclosingMethod != null && enclosingConstructor != null) {
            throw VMError.shouldNotReachHere("Class has both an enclosingMethod and an enclosingConstructor: " + clazz + ", " + enclosingMethod + ", " + enclosingConstructor);
        }
        Executable executable = enclosingMethodOrConstructor = enclosingMethod != null ? enclosingMethod : enclosingConstructor;
        if (this.reflectionMethods.contains(enclosingMethodOrConstructor)) {
            return enclosingMethodOrConstructor;
        }
        return null;
    }

    private static Field[] filterFields(Object fields, Set<Field> filterSet, AnalysisMetaAccess metaAccess) {
        return ReflectionDataBuilder.filterFields(fields, filterSet::contains, metaAccess);
    }

    private static boolean isHiddenIn(Field field, Class<?> clazz) {
        try {
            return !clazz.getField(field.getName()).equals(field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Field[] filterFields(Object fields, Predicate<Field> filter, AnalysisMetaAccess metaAccess) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : (Field[])fields) {
            if (!filter.test(field) || SubstitutionReflectivityFilter.shouldExclude(field, metaAccess)) continue;
            try {
                if (metaAccess.lookupJavaField(field).isAnnotationPresent(Delete.class)) continue;
                result.add(field);
            }
            catch (DeletedElementException deletedElementException) {
                // empty catch block
            }
        }
        return result.toArray(new Field[0]);
    }

    private static Constructor<?>[] filterConstructors(Object methods, Set<Executable> filter, AnalysisMetaAccess metaAccess) {
        return (Constructor[])ReflectionDataBuilder.filterMethods((Object)methods, filter, (AnalysisMetaAccess)metaAccess, (Executable[])new Constructor[0]);
    }

    private static Method[] filterMethods(Object methods, Set<Executable> filter, AnalysisMetaAccess metaAccess) {
        return (Method[])ReflectionDataBuilder.filterMethods((Object)methods, filter, (AnalysisMetaAccess)metaAccess, (Executable[])new Method[0]);
    }

    private static <T extends Executable> T[] filterMethods(Object methods, Set<Executable> filter, AnalysisMetaAccess metaAccess, T[] prototypeArray) {
        ArrayList<Executable> result = new ArrayList<Executable>();
        for (Executable method : (Executable[])methods) {
            if (!filter.contains(method) || SubstitutionReflectivityFilter.shouldExclude(method, metaAccess)) continue;
            result.add(method);
        }
        return (Executable[])result.toArray(prototypeArray);
    }

    private static Class<?>[] filterClasses(Object classes, Set<Class<?>> filter, AnalysisMetaAccess metaAccess) {
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class clazz : (Class[])classes) {
            if (!filter.contains(clazz) || SubstitutionReflectivityFilter.shouldExclude(clazz, metaAccess)) continue;
            result.add(clazz);
        }
        return result.toArray(new Class[0]);
    }

    boolean inspectFinalFieldWritableForAnalysis(Field field) {
        assert (Modifier.isFinal(field.getModifiers()));
        EnumSet<FieldFlag> flags = this.reflectionFields.getOrDefault(field, NO_FIELD_FLAGS);
        this.analyzedFinalFields.add(field);
        return flags.contains((Object)FieldFlag.FINAL_BUT_WRITABLE);
    }

    private static enum FieldFlag {
        FINAL_BUT_WRITABLE,
        UNSAFE_ACCESSIBLE;

    }
}

