/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.headers.LibC;
import com.oracle.svm.core.windows.headers.Process;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class WindowsVMThreads
extends VMThreads {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected ComparableWord getCurrentOSThreadId() {
        return WordFactory.unsigned((int)Process.GetCurrentThreadId());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    protected boolean initializeOnce() {
        WindowsVMLockSupport.initialize();
        return true;
    }

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    public IsolateThread allocateIsolateThread(int isolateThreadSize) {
        return (IsolateThread)LibC.calloc(WordFactory.unsigned((int)1), WordFactory.unsigned((int)isolateThreadSize));
    }

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    public void freeIsolateThread(IsolateThread thread) {
        LibC.free((PointerBase)thread);
    }

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    public void failFatally(int code, CCharPointer message) {
        LibC.exit(code);
    }
}

