/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class UnalignedHeapChunk
extends HeapChunk {
    protected static Pointer getCardTableStart(UnalignedHeader that) {
        return UnalignedHeapChunk.asPointer(that).add(UnalignedHeapChunk.getCardTableStartOffset());
    }

    protected static Pointer getCardTableLimit(UnalignedHeader that) {
        return UnalignedHeapChunk.asPointer(that).add(UnalignedHeapChunk.getCardTableLimitOffset());
    }

    protected static Pointer getObjectStart(UnalignedHeader that) {
        return UnalignedHeapChunk.asPointer(that).add(UnalignedHeapChunk.getObjectStartOffset());
    }

    protected static Pointer getUnalignedStart(UnalignedHeader that) {
        return UnalignedHeapChunk.getObjectStart(that);
    }

    public static UnsignedWord getUnalignedHeapOverhead() {
        return UnalignedHeapChunk.getObjectStartOffset();
    }

    private static Pointer getObjectsLimit(UnalignedHeader that) {
        return that.getEnd();
    }

    protected static UnsignedWord getChunkSizeForObject(UnsignedWord objectSize) {
        UnsignedWord objectStart = UnalignedHeapChunk.getObjectStartOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        UnsignedWord result = UnsignedUtils.roundUp(objectStart.add(objectSize), alignment);
        return result;
    }

    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    public static Pointer allocateMemory(UnalignedHeader that, UnsignedWord size) {
        UnsignedWord available = UnalignedHeapChunk.availableObjectMemory(that);
        Pointer result = (Pointer)WordFactory.nullPointer();
        if (size.belowOrEqual(available)) {
            result = that.getTop();
            Pointer newTop = result.add(size);
            UnalignedHeapChunk.setTopCarefully(that, newTop);
        }
        return result;
    }

    protected static UnalignedHeader getEnclosingUnalignedHeapChunk(Object obj) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        return UnalignedHeapChunk.getEnclosingUnalignedHeapChunkFromPointer((Pointer)objPointer);
    }

    private static UnalignedHeader getEnclosingUnalignedHeapChunkFromPointer(Pointer objPointer) {
        UnsignedWord startOffset = UnalignedHeapChunk.getObjectStartOffset();
        Pointer chunkPointer = objPointer.subtract(startOffset);
        UnalignedHeader result = (UnalignedHeader)chunkPointer;
        return result;
    }

    public static boolean walkObjectsOfUnalignedHeapChunk(UnalignedHeader that, ObjectVisitor visitor) {
        return UnalignedHeapChunk.walkObjectsFrom(that, UnalignedHeapChunk.getUnalignedStart(that), visitor);
    }

    public static void dirtyCardForObjectOfUnalignedHeapChunk(Object obj, boolean verifyOnly) {
        UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(obj);
        Pointer cardTableStart = UnalignedHeapChunk.getCardTableStart(chunk);
        UnsignedWord objectIndex = UnalignedHeapChunk.getObjectIndex();
        if (verifyOnly) {
            AssertionNode.assertion((boolean)false, (boolean)CardTable.isDirtyEntryAtIndexUnchecked(cardTableStart, objectIndex), (String)"card must be dirty");
        } else {
            CardTable.dirtyEntryAtIndex(cardTableStart, objectIndex);
        }
    }

    static boolean verifyOnlyCleanCardsOfUnalignedHeapChunk(UnalignedHeader that) {
        Log trace = Log.noopLog().string("[UnalignedHeapChunk.verifyOnlyCleanCards:");
        trace.string("  that: ").hex((WordBase)that);
        boolean result = true;
        Pointer rememberedSetStart = UnalignedHeapChunk.getCardTableStart(that);
        UnsignedWord objectIndex = UnalignedHeapChunk.getObjectIndex();
        if (CardTable.isDirtyEntryAtIndex(rememberedSetStart, objectIndex)) {
            result = false;
            Log witness = Log.log().string("[UnalignedHeapChunk.verifyOnlyCleanCards:");
            witness.string("  that: ").hex((WordBase)that).string("  dirty card at index: ").unsigned((WordBase)objectIndex).string("]").newline();
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    public static boolean walkDirtyObjectsOfUnalignedHeapChunk(UnalignedHeader that, ObjectVisitor visitor, boolean clean) {
        Log trace = Log.noopLog().string("[UnalignedHeapChunk.walkDirtyObjects:");
        trace.string("  clean: ").bool(clean).string("  that: ").hex((WordBase)that).string("  ");
        boolean result = true;
        Pointer rememberedSetStart = UnalignedHeapChunk.getCardTableStart(that);
        UnsignedWord objectIndex = UnalignedHeapChunk.getObjectIndex();
        trace.string("  rememberedSetStart: ").hex((WordBase)rememberedSetStart).string("  objectIndex: ").unsigned((WordBase)objectIndex);
        if (CardTable.isDirtyEntryAtIndex(rememberedSetStart, objectIndex)) {
            Pointer objectsStart = UnalignedHeapChunk.getUnalignedStart(that);
            Object obj = objectsStart.toObject();
            trace.string("  obj: ").object(obj);
            if (!visitor.visitObjectInline(obj)) {
                result = false;
            }
            if (clean) {
                CardTable.cleanEntryAtIndex(rememberedSetStart, objectIndex);
            }
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    protected static void cleanRememberedSetOfUnalignedHeapChunk(UnalignedHeader that) {
        Log trace = Log.noopLog().string("[UnalignedHeapChunk.cleanRememberedSet:").newline();
        trace.string("  that: ").hex((WordBase)that);
        CardTable.cleanTableToPointer(UnalignedHeapChunk.getCardTableStart(that), UnalignedHeapChunk.getCardTableLimit(that));
        trace.string("]").newline();
    }

    protected static void setUpRememberedSetOfUnalignedHeapChunk(UnalignedHeader that) {
        Object obj = UnalignedHeapChunk.getUnalignedStart(that).toObject();
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        ohi.setUnaligned(obj);
    }

    @Fold
    static UnsignedWord getCardTableStartOffset() {
        UnsignedWord headerSize = WordFactory.unsigned((int)SizeOf.get(UnalignedHeader.class));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableSize() {
        UnsignedWord requiredSize = CardTable.tableSizeForMemorySize(WordFactory.unsigned((int)1));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(requiredSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableLimitOffset() {
        UnsignedWord tableStart = UnalignedHeapChunk.getCardTableStartOffset();
        UnsignedWord tableSize = UnalignedHeapChunk.getCardTableSize();
        UnsignedWord tableLimit = tableStart.add(tableSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(tableLimit, alignment);
    }

    @Fold
    static UnsignedWord getObjectStartOffset() {
        UnsignedWord cardTableLimitOffset = UnalignedHeapChunk.getCardTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        UnsignedWord result = UnsignedUtils.roundUp(cardTableLimitOffset, alignment);
        return result;
    }

    private static UnsignedWord getObjectOffset() {
        return (UnsignedWord)WordFactory.zero();
    }

    private static UnsignedWord getObjectIndex() {
        return (UnsignedWord)WordFactory.zero();
    }

    public static Pointer getUnalignedHeapChunkStart(UnalignedHeader that) {
        return UnalignedHeapChunk.getObjectStart(that);
    }

    public static UnsignedWord committedObjectMemoryOfUnalignedHeapChunk(UnalignedHeader that) {
        Pointer start = UnalignedHeapChunk.getUnalignedHeapChunkStart(that);
        Pointer end = that.getEnd();
        Pointer result = end.subtract((UnsignedWord)start);
        return result;
    }

    public static UnsignedWord usedObjectMemoryOfUnalignedHeapChunk(UnalignedHeader that) {
        Pointer start = UnalignedHeapChunk.getUnalignedHeapChunkStart(that);
        Pointer top = that.getTop();
        return top.subtract((UnsignedWord)start);
    }

    static boolean verifyUnalignedHeapChunk(UnalignedHeader that) {
        return UnalignedHeapChunk.verifyUnalignedHeapChunk(that, UnalignedHeapChunk.getUnalignedStart(that));
    }

    private static boolean verifyUnalignedHeapChunk(UnalignedHeader that, Pointer start) {
        VMOperation.guaranteeInProgress("Should only be called as a VMOperation.");
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[UnalignedHeapChunk.verifyUnalignedHeapChunk");
        trace.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)that.getTop()).string("  end: ").hex((WordBase)that.getEnd()).newline();
        UnsignedWord objHeader = ObjectHeader.readHeaderFromPointer(start);
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        if (ohi.isForwardedHeader(objHeader)) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)that.getTop()).string("  end: ").hex((WordBase)that.getEnd());
            witness.string("  space: ").string(that.getSpace().getName());
            witness.string("  objHeader: ").string(ohi.toStringFromHeader(objHeader));
            witness.string("  should not be forwarded").string("]").newline();
            return false;
        }
        if (!ohi.isUnalignedHeader(objHeader)) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  end: ").hex((WordBase)that.getEnd());
            witness.string("  space: ").string(that.getSpace().getName());
            witness.string("  obj: ").hex((WordBase)start).string("  objHeader: ").hex((WordBase)objHeader);
            witness.string("  does not have an unaligned header").string("]").newline();
            return false;
        }
        Object obj = start.toObject();
        Pointer objEnd = LayoutEncoding.getObjectEnd(obj);
        if (objEnd.notEqual((UnsignedWord)that.getTop())) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  end: ").hex((WordBase)that.getEnd());
            witness.string("  space: ").string(that.getSpace().getName());
            witness.string("  obj: ").object(obj).string("  objEnd: ").hex((WordBase)objEnd);
            witness.string("  should be the only object in the chunk").string("]").newline();
            return false;
        }
        if (!UnalignedHeapChunk.verifyRememberedSet(that)) {
            Log witnessLog = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[UnalignedHeadChunk remembered set fails to verify");
            witnessLog.string("  that: ").hex((WordBase)that).string("  remembered set fails to verify.").string("]").newline();
        }
        boolean result = UnalignedHeapChunk.verifyHeapChunk(that, start);
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private static boolean verifyRememberedSet(UnalignedHeader that) {
        UnsignedWord objectIndex;
        Pointer rememberedSet;
        boolean isDirty;
        Pointer objStart;
        Object obj;
        boolean containsYoungReferences;
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        if (that.getSpace() == oldGen.getFromSpace() && (containsYoungReferences = CardTable.containsReferenceToYoungSpace(obj = (objStart = UnalignedHeapChunk.getUnalignedStart(that)).toObject())) && !(isDirty = CardTable.isDirtyEntryAtIndex(rememberedSet = UnalignedHeapChunk.getCardTableStart(that), objectIndex = UnalignedHeapChunk.getObjectIndex()))) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that);
            witness.string("  containsYoungReferences implies isDirty").string("]").newline();
            return false;
        }
        return true;
    }

    @Fold
    public static MemoryWalker.HeapChunkAccess<UnalignedHeader> getMemoryWalkerAccess() {
        return (MemoryWalker.HeapChunkAccess)ImageSingletons.lookup(MemoryWalkerAccessImpl.class);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static UnsignedWord getCardTableStartOffset() {
            return UnalignedHeapChunk.getCardTableStartOffset();
        }

        public static UnsignedWord getObjectStartOffset() {
            return UnalignedHeapChunk.getObjectStartOffset();
        }
    }

    static final class MemoryWalkerAccessImpl
    extends HeapChunk.MemoryWalkerAccessImpl<UnalignedHeader> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        MemoryWalkerAccessImpl() {
        }

        @Override
        public boolean isAligned(UnalignedHeader heapChunk) {
            return false;
        }

        @Override
        public UnsignedWord getAllocationStart(UnalignedHeader heapChunk) {
            return UnalignedHeapChunk.getUnalignedHeapChunkStart(heapChunk);
        }
    }

    @RawStructure
    public static interface UnalignedHeader
    extends HeapChunk.Header<UnalignedHeader> {
    }
}

