/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.ByteArrayReader;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.TypeReader;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeReader;

public class FrameInfoDecoder {
    protected static final int NO_CALLER_BCI = -1;
    protected static final int NO_LOCAL_INFO_BCI = -2;
    static final HeapBasedFrameInfoQueryResultAllocator HeapBasedFrameInfoQueryResultAllocator = new HeapBasedFrameInfoQueryResultAllocator();
    static final HeapBasedValueInfoAllocator HeapBasedValueInfoAllocator = new HeapBasedValueInfoAllocator();
    protected static final int BCI_SHIFT = 2;
    protected static final int DURING_CALL_MASK = 2;
    protected static final int RETHROW_EXCEPTION_MASK = 1;
    protected static final int TYPE_BITS = 3;
    protected static final int TYPE_SHIFT = 0;
    protected static final int TYPE_MASK_IN_PLACE = 7;
    protected static final int KIND_BITS = 4;
    protected static final int KIND_SHIFT = 3;
    protected static final int KIND_MASK_IN_PLACE = 120;
    protected static final int IS_COMPRESSED_REFERENCE_BITS = 1;
    protected static final int IS_COMPRESSED_REFERENCE_SHIFT = 7;
    protected static final int IS_COMPRESSED_REFERENCE_MASK_IN_PLACE = 128;
    private static final FrameInfoQueryResult.ValueType[] ValueTypeValues = FrameInfoQueryResult.ValueType.values();
    private static final JavaKind[] JavaKindValues = JavaKind.values();

    protected static boolean isFrameInfoMatch(long frameInfoIndex, byte[] frameInfoEncodings, long searchEncodedBci) {
        UnsafeArrayTypeReader readBuffer = UnsafeArrayTypeReader.create((byte[])frameInfoEncodings, (long)frameInfoIndex, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        long actualEncodedBci = readBuffer.getSV();
        assert (actualEncodedBci != -1L);
        return actualEncodedBci == searchEncodedBci;
    }

    /*
     * Unable to fully structure code
     */
    protected static FrameInfoQueryResult decodeFrameInfo(boolean isDeoptEntry, TypeReader readBuffer, Object[] frameInfoObjectConstants, Class<?>[] frameInfoSourceClasses, String[] frameInfoSourceMethodNames, String[] frameInfoNames, FrameInfoQueryResultAllocator resultAllocator, ValueInfoAllocator valueInfoAllocator, boolean fetchFirstFrame) {
        result = null;
        prev = null;
        virtualObjects = null;
        block0: while (true) {
            if ((cur = resultAllocator.newFrameInfoQueryResult()) == null) {
                return result;
            }
            encodedBci = readBuffer.getSVInt();
            if (encodedBci == -1) {
                return result;
            }
            cur.encodedBci = encodedBci;
            cur.isDeoptEntry = isDeoptEntry;
            cur.needLocalValues = needLocalValues = encodedBci != -2;
            curValueInfosLenght = 0;
            if (needLocalValues) {
                cur.numLocks = readBuffer.getUVInt();
                cur.numLocals = readBuffer.getUVInt();
                cur.numStack = readBuffer.getUVInt();
                deoptMethodIndex = readBuffer.getSVInt();
                if (deoptMethodIndex < 0) {
                    cur.deoptMethod = (SharedMethod)frameInfoObjectConstants[-1 - deoptMethodIndex];
                    cur.deoptMethodOffset = cur.deoptMethod.getDeoptOffsetInImage();
                } else {
                    cur.deoptMethodOffset = deoptMethodIndex;
                }
                curValueInfosLenght = readBuffer.getUVInt();
                cur.valueInfos = FrameInfoDecoder.decodeValues(valueInfoAllocator, curValueInfosLenght, readBuffer, frameInfoObjectConstants);
            }
            if (prev != null) {
                prev.caller = cur;
                if (!FrameInfoDecoder.$assertionsDisabled && isDeoptEntry) {
                    throw new AssertionError((Object)"Deoptimization entry must not have inlined frames");
                }
            } else if (!fetchFirstFrame) {
                result = cur;
            } else {
                result = cur;
                if (needLocalValues) {
                    numVirtualObjects = readBuffer.getUVInt();
                    virtualObjects = valueInfoAllocator.newValueInfoArrayArray(numVirtualObjects);
                    for (i = 0; i < numVirtualObjects; ++i) {
                        numValues = readBuffer.getUVInt();
                        decodedValues = FrameInfoDecoder.decodeValues(valueInfoAllocator, numValues, readBuffer, frameInfoObjectConstants);
                        if (virtualObjects == null) continue;
                        virtualObjects[i] = decodedValues;
                    }
                }
            }
            prev = cur;
            cur.virtualObjects = virtualObjects;
            v0 = debugNames = needLocalValues != false && FrameInfoDecoder.encodeDebugNames() != false;
            if (debugNames || FrameInfoDecoder.encodeSourceReferences()) {
                sourceClassIndex = readBuffer.getSVInt();
                sourceMethodNameIndex = readBuffer.getSVInt();
                sourceLineNumber = readBuffer.getSVInt();
                cur.sourceClassIndex = sourceClassIndex;
                cur.sourceMethodNameIndex = sourceMethodNameIndex;
                cur.sourceClass = frameInfoSourceClasses[sourceClassIndex];
                cur.sourceMethodName = frameInfoSourceMethodNames[sourceMethodNameIndex];
                cur.sourceLineNumber = sourceLineNumber;
            }
            if (!debugNames) continue;
            i = 0;
            while (true) {
                if (i < curValueInfosLenght) ** break;
                continue block0;
                nameIndex = readBuffer.getUVInt();
                if (cur.valueInfos != null) {
                    cur.valueInfos[i].nameIndex = nameIndex;
                    cur.valueInfos[i].name = frameInfoNames[nameIndex];
                }
                ++i;
            }
            break;
        }
    }

    private static FrameInfoQueryResult.ValueInfo[] decodeValues(ValueInfoAllocator valueInfoAllocator, int numValues, TypeReader readBuffer, Object[] frameInfoObjectConstants) {
        FrameInfoQueryResult.ValueInfo[] valueInfos = valueInfoAllocator.newValueInfoArray(numValues);
        for (int i = 0; i < numValues; ++i) {
            FrameInfoQueryResult.ValueInfo valueInfo = valueInfoAllocator.newValueInfo();
            if (valueInfos != null) {
                valueInfos[i] = valueInfo;
            }
            int flags = readBuffer.getU1();
            FrameInfoQueryResult.ValueType valueType = FrameInfoDecoder.extractType(flags);
            if (valueInfo != null) {
                valueInfo.type = valueType;
                valueInfo.kind = FrameInfoDecoder.extractKind(flags);
                valueInfo.isCompressedReference = FrameInfoDecoder.extractIsCompressedReference(flags);
            }
            if (valueType.hasData) {
                long valueInfoData = readBuffer.getSV();
                if (valueInfo != null) {
                    valueInfo.data = valueInfoData;
                }
            }
            valueInfoAllocator.decodeConstant(valueInfo, frameInfoObjectConstants);
        }
        return valueInfos;
    }

    protected static boolean encodeDebugNames() {
        return false;
    }

    protected static boolean encodeSourceReferences() {
        return SubstrateOptions.StackTrace.getValue();
    }

    protected static int decodeBci(long encodedBci) {
        return TypeConversion.asS4((long)(encodedBci >> 2));
    }

    public static String readableBci(long encodedBci) {
        return FrameInfoDecoder.decodeBci(encodedBci) + ((encodedBci & 2L) != 0L ? " duringCall" : "") + ((encodedBci & 1L) != 0L ? " rethrowException" : "");
    }

    private static FrameInfoQueryResult.ValueType extractType(int flags) {
        return ValueTypeValues[(flags & 7) >> 0];
    }

    private static JavaKind extractKind(int flags) {
        return JavaKindValues[(flags & 0x78) >> 3];
    }

    private static boolean extractIsCompressedReference(int flags) {
        return (flags & 0x80) != 0;
    }

    static class HeapBasedValueInfoAllocator
    implements ValueInfoAllocator {
        HeapBasedValueInfoAllocator() {
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
        public FrameInfoQueryResult.ValueInfo newValueInfo() {
            return new FrameInfoQueryResult.ValueInfo();
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
        public FrameInfoQueryResult.ValueInfo[] newValueInfoArray(int len) {
            return new FrameInfoQueryResult.ValueInfo[len];
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
        public FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(int len) {
            return new FrameInfoQueryResult.ValueInfo[len][];
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
        public void decodeConstant(FrameInfoQueryResult.ValueInfo valueInfo, Object[] frameInfoObjectConstants) {
            block0 : switch (valueInfo.type) {
                case DefaultConstant: {
                    switch (valueInfo.kind) {
                        case Object: {
                            valueInfo.value = SubstrateObjectConstant.forObject(null, valueInfo.isCompressedReference);
                            assert (valueInfo.value.isDefaultForKind());
                            break block0;
                        }
                    }
                    valueInfo.value = JavaConstant.defaultForKind((JavaKind)valueInfo.kind);
                    break;
                }
                case Constant: {
                    switch (valueInfo.kind) {
                        case Object: {
                            valueInfo.value = SubstrateObjectConstant.forObject(frameInfoObjectConstants[TypeConversion.asS4((long)valueInfo.data)], valueInfo.isCompressedReference);
                            break block0;
                        }
                        case Float: {
                            valueInfo.value = JavaConstant.forFloat((float)Float.intBitsToFloat(TypeConversion.asS4((long)valueInfo.data)));
                            break block0;
                        }
                        case Double: {
                            valueInfo.value = JavaConstant.forDouble((double)Double.longBitsToDouble(valueInfo.data));
                            break block0;
                        }
                    }
                    assert (valueInfo.kind.isNumericInteger());
                    valueInfo.value = JavaConstant.forIntegerKind((JavaKind)valueInfo.kind, (long)valueInfo.data);
                }
            }
        }
    }

    public static interface ValueInfoAllocator {
        public FrameInfoQueryResult.ValueInfo newValueInfo();

        public FrameInfoQueryResult.ValueInfo[] newValueInfoArray(int var1);

        public FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(int var1);

        public void decodeConstant(FrameInfoQueryResult.ValueInfo var1, Object[] var2);
    }

    static class HeapBasedFrameInfoQueryResultAllocator
    implements FrameInfoQueryResultAllocator {
        HeapBasedFrameInfoQueryResultAllocator() {
        }

        @Override
        public FrameInfoQueryResult newFrameInfoQueryResult() {
            return new FrameInfoQueryResult();
        }
    }

    public static interface FrameInfoQueryResultAllocator {
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
        public FrameInfoQueryResult newFrameInfoQueryResult();
    }
}

