/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.code.AbstractCodeInfo;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTableCounters;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.RuntimeCodeInfo;
import com.oracle.svm.core.code.RuntimeMethodInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class CodeInfoTable {
    public static ImageCodeInfo getImageCodeCache() {
        return (ImageCodeInfo)ImageSingletons.lookup(ImageCodeInfo.class);
    }

    @Fold
    public static RuntimeCodeInfo getRuntimeCodeCache() {
        return (RuntimeCodeInfo)ImageSingletons.lookup(RuntimeCodeInfo.class);
    }

    public static CodeInfoQueryResult lookupCodeInfoQueryResult(CodePointer ip) {
        CodeInfoTable.counters().lookupCodeInfoCount.inc();
        AbstractCodeInfo data = CodeInfoTable.lookupCodeInfo(ip);
        if (data == null) {
            return null;
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        result.data = data;
        result.ip = ip;
        data.lookupCodeInfo(data.relativeIP(ip), result);
        return result;
    }

    public static CodeInfoQueryResult lookupDeoptimizationEntrypoint(int deoptOffsetInImage, long encodedBci) {
        CodeInfoTable.counters().lookupDeoptimizationEntrypointCount.inc();
        ImageCodeInfo data = CodeInfoTable.getImageCodeCache();
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = data.lookupDeoptimizationEntrypoint(deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return null;
        }
        result.data = data;
        result.ip = data.absoluteIP(relativeIP);
        return result;
    }

    public static long lookupTotalFrameSize(CodePointer ip) {
        CodeInfoTable.counters().lookupTotalFrameSizeCount.inc();
        AbstractCodeInfo data = CodeInfoTable.lookupCodeInfo(ip);
        if (data == null) {
            return -1L;
        }
        return data.lookupTotalFrameSize(data.relativeIP(ip));
    }

    public static long lookupExceptionOffset(CodePointer ip) {
        CodeInfoTable.counters().lookupExceptionOffsetCount.inc();
        AbstractCodeInfo data = CodeInfoTable.lookupCodeInfo(ip);
        if (data == null) {
            return -1L;
        }
        return data.lookupExceptionOffset(data.relativeIP(ip));
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean visitObjectReferences(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, ObjectReferenceVisitor visitor) {
        CodeInfoTable.counters().visitObjectReferencesCount.inc();
        if (deoptimizedFrame != null) {
            return true;
        }
        byte[] referenceMapEncoding = null;
        long referenceMapIndex = -1L;
        AbstractCodeInfo data = CodeInfoTable.lookupCodeInfo(ip);
        if (data != null) {
            referenceMapEncoding = data.getReferenceMapEncoding();
            referenceMapIndex = data.lookupReferenceMapIndex(data.relativeIP(ip));
        }
        if (referenceMapIndex == -1L) {
            throw CodeInfoTable.reportNoReferenceMap(sp, ip, deoptimizedFrame, data);
        }
        return CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, visitor);
    }

    private static RuntimeException reportNoReferenceMap(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, AbstractCodeInfo data) {
        Log.log().string("ip: ").hex((WordBase)ip).string("  sp: ").hex((WordBase)sp);
        Log.log().string("  deoptFrame: ").object(deoptimizedFrame).string("  data:").object(data).newline();
        throw VMError.shouldNotReachHere("No reference map information found");
    }

    public static SubstrateInstalledCode lookupInstalledCode(CodePointer ip) {
        CodeInfoTable.counters().lookupInstalledCodeCount.inc();
        RuntimeMethodInfo methodInfo = CodeInfoTable.getRuntimeCodeCache().lookupMethod(ip);
        return methodInfo != null ? (SubstrateInstalledCode)methodInfo.installedCode.get() : null;
    }

    public static void invalidateInstalledCode(SubstrateInstalledCode installedCode) {
        VMOperation.enqueueBlockingSafepoint("CodeInfoTable.invalidateInstalledCode", () -> {
            CodeInfoTable.counters().invalidateInstalledCodeCount.inc();
            if (installedCode.isValid()) {
                RuntimeCodeInfo codeCache = CodeInfoTable.getRuntimeCodeCache();
                RuntimeMethodInfo methodInfo = codeCache.lookupMethod((CodePointer)WordFactory.pointer((long)installedCode.getAddress()));
                long num = codeCache.logMethodOperation(methodInfo, "Invalidate");
                codeCache.invalidateMethod(methodInfo);
                codeCache.logMethodOperationEnd(num);
            }
        });
    }

    public static AbstractCodeInfo lookupCodeInfo(CodePointer ip) {
        if (CodeInfoTable.getImageCodeCache().contains(ip)) {
            return CodeInfoTable.getImageCodeCache();
        }
        return CodeInfoTable.getRuntimeCodeCache().lookupMethod(ip);
    }

    public static Log logCodeInfoResult(Log log, CodePointer ip) {
        AbstractCodeInfo data = CodeInfoTable.lookupCodeInfo(ip);
        if (data == null) {
            return log.string("No CodeInfo for IP ").zhex(ip.rawValue());
        }
        log.object(data);
        return log.string(" name = ").string(data.getName());
    }

    private static CodeInfoTableCounters counters() {
        return (CodeInfoTableCounters)ImageSingletons.lookup(CodeInfoTableCounters.class);
    }

    public static class Options {
        @Option(help={"Count accesses to the image and runtime code info table"})
        public static final HostedOptionKey<Boolean> CodeCacheCounters = new HostedOptionKey<Boolean>(false);
    }
}

