/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.reflect.hosted.ReflectionDataBuilder;
import com.oracle.svm.reflect.hosted.ReflectionSubstitution;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticFeature
public final class ReflectionFeature
implements GraalFeature {
    private AnnotationSubstitutionProcessor annotationSubstitutions;
    private ReflectionDataBuilder reflectionData;
    private ImageClassLoader loader;
    private SVMHost hostVM;
    private int loadedConfigurations;

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.hostVM = access.getHostVM();
        ReflectionSubstitution subst = new ReflectionSubstitution(access.getMetaAccess().getWrapped(), access.getHostVM().getClassInitializationSupport(), access.getImageClassLoader());
        access.registerSubstitutionProcessor(subst);
        ImageSingletons.add(ReflectionSubstitution.class, (Object)((Object)subst));
        this.reflectionData = new ReflectionDataBuilder();
        ImageSingletons.add(RuntimeReflectionSupport.class, (Object)this.reflectionData);
        ReflectionConfigurationParser<Class<?>> parser = ConfigurationParserUtils.create((ReflectionRegistry)this.reflectionData, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "reflection", ConfigurationFiles.Options.ReflectionConfigurationFiles, ConfigurationFiles.Options.ReflectionConfigurationResources, "reflect-config.json");
        this.loader = access.getImageClassLoader();
        this.annotationSubstitutions = ((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reflectionData.duringAnalysis(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.reflectionData.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest reflectionFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).reflectionFallback;
        if (reflectionFallback != null && this.loadedConfigurations == 0) {
            throw reflectionFallback;
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        ReflectionPlugins.registerInvocationPlugins(this.loader, snippetReflection, this.annotationSubstitutions, invocationPlugins, this.hostVM, analysis, hosted);
    }
}

