/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaField;

public class HostedField
implements ReadableJavaField,
SharedField,
Comparable<HostedField> {
    private final HostedUniverse universe;
    private final HostedMetaAccess metaAccess;
    public final AnalysisField wrapped;
    private final HostedType holder;
    private final HostedType type;
    protected int location;
    private final JavaTypeProfile typeProfile;
    private static final int LOC_UNMATERIALIZED_STATIC_CONSTANT = -10;

    public HostedField(HostedUniverse universe, HostedMetaAccess metaAccess, AnalysisField wrapped, HostedType holder, HostedType type, JavaTypeProfile typeProfile) {
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.wrapped = wrapped;
        this.holder = holder;
        this.type = type;
        this.typeProfile = typeProfile;
        this.location = -1;
    }

    public JavaTypeProfile getFieldTypeProfile() {
        return this.typeProfile;
    }

    protected void setLocation(int location) {
        assert (this.location == -1);
        assert (location >= 0);
        this.location = location;
    }

    protected void setUnmaterializedStaticConstant() {
        assert (this.location == -1 && this.isStatic());
        this.location = -10;
    }

    public JavaConstant getConstantValue() {
        if (this.isStatic() && this.allowConstantFolding()) {
            return this.readValue(null);
        }
        return null;
    }

    public boolean hasLocation() {
        return this.location >= 0;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isAccessed() {
        return this.wrapped.isAccessed();
    }

    @Override
    public boolean isWritten() {
        return this.wrapped.isWritten();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public HostedType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        return this.wrapped.getOffset();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public JavaConstant readValue(JavaConstant receiver) {
        JavaConstant wrappedReceiver = receiver != null && SubstrateObjectConstant.asObject((Constant)receiver) instanceof Class ? SubstrateObjectConstant.forObject(this.metaAccess.lookupJavaType((Class)SubstrateObjectConstant.asObject((Constant)receiver)).getHub()) : receiver;
        return this.universe.lookup(this.universe.getConstantReflectionProvider().readFieldValue((ResolvedJavaField)this.wrapped, wrappedReceiver));
    }

    @Override
    public boolean allowConstantFolding() {
        if (this.location == -10) {
            return true;
        }
        if (!this.wrapped.isWritten()) {
            return true;
        }
        return Modifier.isFinal(this.getModifiers()) && !Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return ReadableJavaField.injectFinalForRuntimeCompilation((ResolvedJavaField)this.wrapped);
    }

    public JavaConstant readStorageValue(JavaConstant receiver) {
        JavaConstant result = this.readValue(receiver);
        assert (result.getJavaKind() == this.getType().getStorageKind()) : this;
        return result;
    }

    public HostedType getDeclaringClass() {
        return this.holder;
    }

    public boolean isInternal() {
        return this.wrapped.isInternal();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public Annotation[] getAnnotations() {
        return this.wrapped.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.wrapped.getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.wrapped.getAnnotation(annotationClass);
    }

    public String toString() {
        return "HostedField<" + this.format("%h.%n") + " location: " + this.location + "   " + this.wrapped.toString() + ">";
    }

    @Override
    public JavaKind getStorageKind() {
        return this.getType().getStorageKind();
    }

    @Override
    public int compareTo(HostedField other) {
        int result = other.getJavaKind().ordinal() - this.getJavaKind().ordinal();
        return result;
    }
}

