/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers.linux;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
@Platforms(value={Platform.LINUX.class})
public class LinuxSched {
    @CFunction
    public static native int sched_setaffinity(int var0, int var1, cpu_set_t var2);

    @CFunction
    public static native int sched_getaffinity(int var0, int var1, cpu_set_t var2);

    @CFunction
    static native int __sched_cpucount(int var0, cpu_set_t var1);

    public static int CPU_COUNT_S(int cpu_set_size, cpu_set_t set_ptr) {
        return LinuxSched.__sched_cpucount(cpu_set_size, set_ptr);
    }

    @CStruct
    public static interface cpu_set_t
    extends PointerBase {
    }
}

