/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;
import sun.misc.Unsafe;

public class UninterruptibleUtils {

    public static class Integer {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int numberOfLeadingZeros(int i) {
            if (i == 0) {
                return 32;
            }
            int n = 1;
            if (i >>> 16 == 0) {
                n += 16;
                i <<= 16;
            }
            if (i >>> 24 == 0) {
                n += 8;
                i <<= 8;
            }
            if (i >>> 28 == 0) {
                n += 4;
                i <<= 4;
            }
            if (i >>> 30 == 0) {
                n += 2;
                i <<= 2;
            }
            return n -= i >>> 31;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int highestOneBit(int i) {
            i |= i >> 1;
            i |= i >> 2;
            i |= i >> 4;
            i |= i >> 8;
            i |= i >> 16;
            return i - (i >>> 1);
        }
    }

    public static class Long {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int numberOfLeadingZeros(long i) {
            if (i == 0L) {
                return 64;
            }
            int n = 1;
            int x = (int)(i >>> 32);
            if (x == 0) {
                n += 32;
                x = (int)i;
            }
            if (x >>> 16 == 0) {
                n += 16;
                x <<= 16;
            }
            if (x >>> 24 == 0) {
                n += 8;
                x <<= 8;
            }
            if (x >>> 28 == 0) {
                n += 4;
                x <<= 4;
            }
            if (x >>> 30 == 0) {
                n += 2;
                x <<= 2;
            }
            return n -= x >>> 31;
        }
    }

    public static class Math {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int min(int a, int b) {
            return a <= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int max(int a, int b) {
            return a >= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long max(long a, long b) {
            return a >= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long abs(long a) {
            return a < 0L ? -a : a;
        }
    }

    public static class AtomicReference<T> {
        private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile T value;

        public AtomicReference() {
        }

        public AtomicReference(T value) {
            this.value = value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public T get() {
            return this.value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(T newValue) {
            this.value = newValue;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(T expected, T update) {
            return UNSAFE.compareAndSwapObject(this, VALUE_OFFSET, expected, update);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final T getAndSet(T newValue) {
            return (T)UNSAFE.getAndSetObject(this, VALUE_OFFSET, newValue);
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicReference.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static class AtomicPointer<T extends PointerBase> {
        private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile long value;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public T get() {
            return (T)WordFactory.pointer((long)this.value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(T newValue) {
            this.value = newValue.rawValue();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(T expected, T update) {
            return UNSAFE.compareAndSwapLong(this, VALUE_OFFSET, expected.rawValue(), update.rawValue());
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicPointer.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static class AtomicInteger {
        private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile int value;

        public AtomicInteger(int value) {
            this.value = value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int get() {
            return this.value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(int newValue) {
            this.value = newValue;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int incrementAndGet() {
            return UNSAFE.getAndAddInt(this, VALUE_OFFSET, 1) + 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int decrementAndGet() {
            return UNSAFE.getAndAddInt(this, VALUE_OFFSET, -1) - 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(int expected, int update) {
            return UNSAFE.compareAndSwapInt(this, VALUE_OFFSET, expected, update);
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }
}

