/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;

@TargetClass(value=Enum.class)
final class Target_java_lang_Enum {
    Target_java_lang_Enum() {
    }

    @Substitute
    private static Enum<?> valueOf(Class<Enum<?>> enumType, String name) {
        Enum<?>[] enumConstants = DynamicHub.fromClass(enumType).getEnumConstantsShared();
        if (enumConstants == null) {
            throw new IllegalArgumentException(enumType.getName() + " is not an enum type");
        }
        for (Enum<?> e : enumConstants) {
            if (!e.name().equals(name)) continue;
            return e;
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getName() + "." + name);
    }
}

