/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.thread.Safepoint;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode
public class AMD64DecrementingSafepointCheckOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64DecrementingSafepointCheckOp> TYPE = LIRInstructionClass.create(AMD64DecrementingSafepointCheckOp.class);

    protected AMD64DecrementingSafepointCheckOp() {
        super(TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue());
        SubstrateRegisterConfig threadRegister = (SubstrateRegisterConfig)crb.codeCache.getRegisterConfig();
        masm.decrementl(new AMD64Address(threadRegister.getThreadRegister(), Math.toIntExact(Safepoint.getThreadLocalSafepointRequestedOffset())), 1);
    }
}

