/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.Java_lang_Process_Supplement;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.Executor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(className="java.lang.ProcessHandleImpl", onlyWith={JDK11OrLater.class})
final class Target_java_lang_ProcessHandleImpl {
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    @Delete
    static Executor processReaperExecutor;

    Target_java_lang_ProcessHandleImpl() {
    }

    @Substitute
    private static long isAlive0(long pid) {
        return ProcessProperties.isAlive((long)pid) ? 0L : -1L;
    }

    @Substitute
    private static int waitForProcessExit0(long pid, boolean reapvalue) {
        return Java_lang_Process_Supplement.waitForProcessExit0(pid, reapvalue);
    }

    @Substitute
    private static long getCurrentPid0() {
        return ProcessProperties.getProcessID();
    }

    @Substitute
    private static boolean destroy0(long pid, long startTime, boolean forcibly) {
        VMError.guarantee(startTime == 0L, "startTime != 0 currently not supported");
        if (forcibly) {
            return ProcessProperties.destroyForcibly((long)pid);
        }
        return ProcessProperties.destroy((long)pid);
    }

    @Substitute
    private static void initNative() {
    }
}

