/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.headers.Limits;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CTypeConversion;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
@TargetClass(className="java.io.UnixFileSystem", onlyWith={JDK11OrLater.class})
final class Target_java_io_UnixFileSystem_JDK11OrLater {
    Target_java_io_UnixFileSystem_JDK11OrLater() {
    }

    @Substitute
    long getNameMax0(String pathName) {
        long length;
        try (CTypeConversion.CCharPointerHolder path = CTypeConversion.toCString((CharSequence)pathName);){
            length = Unistd.pathconf(path.get(), Unistd._PC_NAME_MAX());
        }
        return length != -1L ? length : (long)Limits.NAME_MAX();
    }
}

