/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.config.ConfigurationParser;
import com.oracle.svm.hosted.config.ReflectionConfigurationParser;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.reflect.hosted.ReflectionDataBuilder;
import com.oracle.svm.reflect.hosted.ReflectionSubstitution;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticFeature
public final class ReflectionFeature
implements GraalFeature {
    private AnnotationSubstitutionProcessor annotationSubstitutions;
    private ReflectionDataBuilder reflectionData;
    private ImageClassLoader loader;

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ReflectionSubstitution subst = new ReflectionSubstitution(access.getMetaAccess().getWrapped(), access.getHostVM().getClassInitializationSupport(), access.getImageClassLoader());
        access.registerSubstitutionProcessor(subst);
        ImageSingletons.add(ReflectionSubstitution.class, (Object)((Object)subst));
        this.reflectionData = new ReflectionDataBuilder();
        ImageSingletons.add(RuntimeReflectionSupport.class, (Object)this.reflectionData);
        ReflectionConfigurationParser<Class<?>> parser = ReflectionConfigurationParser.create((ReflectionRegistry)this.reflectionData, access.getImageClassLoader());
        ConfigurationParser.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "reflection", Options.ReflectionConfigurationFiles, Options.ReflectionConfigurationResources, "reflect-config.json");
        this.loader = access.getImageClassLoader();
        this.annotationSubstitutions = ((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reflectionData.duringAnalysis(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.reflectionData.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest reflectionFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).reflectionFallback;
        if (reflectionFallback != null && Options.ReflectionConfigurationFiles.getValue() == null && Options.ReflectionConfigurationResources.getValue() == null) {
            throw reflectionFallback;
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        ReflectionPlugins.registerInvocationPlugins(this.loader, snippetReflection, this.annotationSubstitutions, invocationPlugins, analysis, hosted);
    }

    public static class Options {
        @Option(help={"file:doc-files/ReflectionConfigurationFilesHelp.txt"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ReflectionConfigurationFiles = new HostedOptionKey<Object>(null);
        @Option(help={"Resources describing program elements to be made available for reflection (see ReflectionConfigurationFiles)."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ReflectionConfigurationResources = new HostedOptionKey<Object>(null);
    }
}

