/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.NativeImageOptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.word.WordTypes;

public abstract class SharedGraphBuilderPhase
extends GraphBuilderPhase.Instance {
    final WordTypes wordTypes;

    public SharedGraphBuilderPhase(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes) {
        super((CoreProviders)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        this.wordTypes = wordTypes;
    }

    public static abstract class SharedBytecodeParser
    extends BytecodeParser {
        private final boolean explicitExceptionEdges;

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
            this.explicitExceptionEdges = explicitExceptionEdges;
        }

        protected RuntimeException throwParserError(Throwable e) {
            if (e instanceof UserError.UserException) {
                throw (UserError.UserException)e;
            }
            throw super.throwParserError(e);
        }

        protected WordTypes getWordTypes() {
            return ((SharedGraphBuilderPhase)this.getGraphBuilderInstance()).wordTypes;
        }

        protected void maybeEagerlyResolve(int cpi, int bytecode) {
            block2: {
                try {
                    super.maybeEagerlyResolve(cpi, bytecode);
                }
                catch (UnresolvedElementException e) {
                    if (e.getCause() instanceof NoClassDefFoundError) break block2;
                    throw e;
                }
            }
        }

        protected void handleUnresolvedNewInstance(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewObjectArray(JavaType type, ValueNode length) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewMultiArray(JavaType type, ValueNode[] dims) {
            this.handleUnresolvedType(type.getElementalType());
        }

        protected void handleUnresolvedInstanceOf(JavaType type, ValueNode object) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedCheckCast(JavaType type, ValueNode object) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedLoadConstant(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedExceptionType(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedStoreField(JavaField field, ValueNode value, ValueNode receiver) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedLoadField(JavaField field, ValueNode receiver) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedInvoke(JavaMethod javaMethod, CallTargetNode.InvokeKind invokeKind) {
            this.handleUnresolvedMethod(javaMethod);
        }

        private void handleUnresolvedType(JavaType type) {
            if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                ExceptionSynthesizer.throwNoClassDefFoundError((GraphBuilderContext)this, type.toJavaName());
            } else {
                SharedBytecodeParser.reportUnresolvedElement("type", type.toJavaName());
            }
        }

        private void handleUnresolvedField(JavaField field) {
            JavaType declaringClass = field.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                ExceptionSynthesizer.throwNoSuchFieldError((GraphBuilderContext)this, field.format("%H.%n"));
            } else {
                SharedBytecodeParser.reportUnresolvedElement("field", field.format("%H.%n"));
            }
        }

        private void handleUnresolvedMethod(JavaMethod javaMethod) {
            JavaType declaringClass = javaMethod.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                ExceptionSynthesizer.throwNoSuchMethodError((GraphBuilderContext)this, javaMethod.format("%H.%n(%P)"));
            } else {
                SharedBytecodeParser.reportUnresolvedElement("method", javaMethod.format("%H.%n(%P)"));
            }
        }

        private static void reportUnresolvedElement(String elementKind, String elementAsString) {
            String message = "Discovered unresolved " + elementKind + " during parsing: " + elementAsString + ". To diagnose the issue you can use the " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " option. The missing " + elementKind + " is then reported at run time when it is accessed the first time.";
            throw new UnresolvedElementException(message);
        }

        protected void emitCheckForInvokeSuperSpecial(ValueNode[] args) {
        }

        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        protected void genIf(ValueNode x, Condition cond, ValueNode y) {
            if (x.getStackKind() == JavaKind.Object && y.getStackKind() == this.getWordTypes().getWordKind() || x.getStackKind() == this.getWordTypes().getWordKind() && y.getStackKind() == JavaKind.Object) {
                throw UserError.abort("Should not compare Word to Object in condition at " + this.method.format("%H.%n(%p)") + " in " + this.method.asStackTraceElement(this.bci()));
            }
            super.genIf(x, cond, y);
        }

        protected boolean shouldComplementProbability() {
            return !HostedConfiguration.instance().isUsingAOTProfiles();
        }

        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
            boolean isStatic = targetMethod.isStatic();
            if (!isStatic) {
                this.checkWordType(args[0], (JavaType)targetMethod.getDeclaringClass(), "call receiver");
            }
            for (int i = 0; i < targetMethod.getSignature().getParameterCount(false); ++i) {
                this.checkWordType(args[i + (isStatic ? 0 : 1)], targetMethod.getSignature().getParameterType(i, null), "call argument");
            }
            return super.createMethodCallTarget(invokeKind, targetMethod, args, returnStamp, profile);
        }

        protected void genReturn(ValueNode returnVal, JavaKind returnKind) {
            this.checkWordType(returnVal, this.method.getSignature().getReturnType(null), "return value");
            super.genReturn(returnVal, returnKind);
        }

        private void checkWordType(ValueNode value, JavaType expectedType, String reason) {
            if (expectedType.getJavaKind() == JavaKind.Object) {
                boolean isWordValue;
                boolean isWordTypeExpected = this.getWordTypes().isWord(expectedType);
                boolean bl = isWordValue = value.getStackKind() == this.getWordTypes().getWordKind();
                if (isWordTypeExpected && !isWordValue) {
                    throw UserError.abort("Expected Word but got Object for " + reason + " in " + this.method.asStackTraceElement(this.bci()));
                }
                if (!isWordTypeExpected && isWordValue) {
                    throw UserError.abort("Expected Object but got Word for " + reason + " in " + this.method.asStackTraceElement(this.bci()));
                }
            }
        }

        protected boolean needsExplicitNullCheckException(ValueNode object) {
            return this.needsExplicitException() && object.getStackKind() == JavaKind.Object;
        }

        protected boolean needsExplicitStoreCheckException(ValueNode array, ValueNode value) {
            return this.needsExplicitException() && value.getStackKind() == JavaKind.Object;
        }

        public boolean needsExplicitException() {
            return this.explicitExceptionEdges && !this.parsingIntrinsic();
        }

        protected BytecodeParser.IntrinsicGuard guardIntrinsic(ValueNode[] args, ResolvedJavaMethod targetMethod, InvocationPlugins.InvocationPluginReceiver pluginReceiver) {
            return null;
        }

        public void notifyReplacedCall(ResolvedJavaMethod targetMethod, ConstantNode node) {
            JavaConstant constant = node.asJavaConstant();
            if (this.getMetaAccess() instanceof AnalysisMetaAccess && constant.getJavaKind() == JavaKind.Object && constant.isNonNull()) {
                SubstrateObjectConstant sValue = (SubstrateObjectConstant)node.asJavaConstant();
                sValue.setRoot(targetMethod);
            }
        }
    }
}

