/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.image.AbstractBootImage;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class FallbackFeature
implements Feature {
    private static final String ABORT_MSG_PREFIX = "Aborting stand-alone image build";
    private final List<ReflectionInvocationCheck> reflectionInvocationChecks = new ArrayList<ReflectionInvocationCheck>();
    private final List<String> reflectionCalls = new ArrayList<String>();
    private final List<String> resourceCalls = new ArrayList<String>();
    private final List<String> proxyCalls = new ArrayList<String>();
    private final Set<AutoProxyInvoke> autoProxyInvokes = new HashSet<AutoProxyInvoke>();
    public FallbackImageRequest reflectionFallback = null;
    public FallbackImageRequest resourceFallback = null;
    public FallbackImageRequest proxyFallback = null;

    public void addAutoProxyInvoke(ResolvedJavaMethod method, int bci) {
        this.autoProxyInvokes.add(new AutoProxyInvoke(method, bci));
    }

    private boolean containsAutoProxyInvoke(ResolvedJavaMethod method, int bci) {
        return this.autoProxyInvokes.contains(new AutoProxyInvoke(method, bci));
    }

    private static AnalysisMethod getCallerMethod(InvokeTypeFlow invoke) {
        return (AnalysisMethod)((MethodCallTargetNode)invoke.getSource()).graph().method();
    }

    private void addCheck(Method reflectionMethod, InvokeChecker checker) {
        this.reflectionInvocationChecks.add(new ReflectionInvocationCheck(reflectionMethod, checker));
    }

    public FallbackFeature() {
        try {
            this.addCheck(Class.class.getMethod("forName", String.class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("forName", String.class, Boolean.TYPE, ClassLoader.class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("newInstance", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getMethod", String.class, Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredMethod", String.class, Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getMethods", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredMethods", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getEnclosingMethod", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getConstructor", Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredConstructor", Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getConstructors", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredConstructors", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getEnclosingConstructor", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getField", String.class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getFields", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredFields", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(ClassLoader.class.getMethod("loadClass", String.class), this::collectReflectionInvokes);
            this.addCheck(ClassLoader.class.getMethod("getResource", String.class), this::collectResourceInvokes);
            this.addCheck(ClassLoader.class.getMethod("getSystemResource", String.class), this::collectResourceInvokes);
            this.addCheck(ClassLoader.class.getMethod("getResources", String.class), this::collectResourceInvokes);
            this.addCheck(ClassLoader.class.getMethod("getSystemResources", String.class), this::collectResourceInvokes);
            this.addCheck(Proxy.class.getMethod("getProxyClass", ClassLoader.class, Class[].class), this::collectProxyInvokes);
            this.addCheck(Proxy.class.getMethod("newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class), this::collectProxyInvokes);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere("Registering ReflectionInvocationChecks failed", e);
        }
    }

    private void collectReflectionInvokes(ReflectionInvocationCheck check, InvokeTypeFlow invoke) {
        this.reflectionCalls.add("Reflection method " + check.locationString(invoke));
    }

    private void collectResourceInvokes(ReflectionInvocationCheck check, InvokeTypeFlow invoke) {
        this.resourceCalls.add("Resource access method " + check.locationString(invoke));
    }

    private void collectProxyInvokes(ReflectionInvocationCheck check, InvokeTypeFlow invoke) {
        if (!this.containsAutoProxyInvoke((ResolvedJavaMethod)FallbackFeature.getCallerMethod(invoke), invoke.getLocation().getBci())) {
            this.proxyCalls.add("Dynamic proxy method " + check.locationString(invoke));
        }
    }

    static FallbackImageRequest reportFallback(String message) {
        return FallbackFeature.reportFallback(message, null);
    }

    static FallbackImageRequest reportFallback(String message, Throwable cause) {
        FallbackImageRequest request;
        if (cause instanceof UserError.UserException) {
            ArrayList<String> messages = new ArrayList<String>();
            if (message != null) {
                messages.add(message);
            }
            ((UserError.UserException)cause).getMessages().forEach(messages::add);
            request = new FallbackImageRequest(messages);
            request.initCause(cause.getCause());
        } else {
            String fallbackMessage = message == null && cause != null ? cause.getMessage() : message;
            request = new FallbackImageRequest(fallbackMessage);
            request.initCause(cause);
        }
        throw request;
    }

    static UserError.UserException reportAsFallback(RuntimeException original) {
        if (Options.FallbackThreshold.getValue() == 0) {
            throw UserError.abort(original.getMessage(), original);
        }
        throw FallbackFeature.reportFallback("Aborting stand-alone image build. " + original.getMessage(), original);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return FallbackExecutor.Options.FallbackExecutorMainClass.getValue() == null;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        if (Options.FallbackThreshold.getValue() == 10) {
            FallbackFeature.reportFallback("Aborting stand-alone image build due to native-image option --force-fallback");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        AnalysisMetaAccess metaAccess = access.getBigBang().getMetaAccess();
        for (ReflectionInvocationCheck check : this.reflectionInvocationChecks) {
            check.trackMethod(metaAccess);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess a) {
        if (Options.FallbackThreshold.getValue() == 0 || NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue() || NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue() || !AbstractBootImage.NativeImageKind.EXECUTABLE.name().equals(NativeImageOptions.Kind.getValue())) {
            return;
        }
        FeatureImpl.AfterAnalysisAccessImpl access = (FeatureImpl.AfterAnalysisAccessImpl)a;
        if (access.getBigBang().getUnsupportedFeatures().exist()) {
            String optionString = SubstrateOptionsParser.commandArgument(PointstoOptions.ReportUnsupportedFeaturesDuringAnalysis, "+");
            FallbackFeature.reportFallback("Aborting stand-alone image build due to unsupported features (use " + optionString + " for report)");
        }
        for (ReflectionInvocationCheck check : this.reflectionInvocationChecks) {
            for (InvokeTypeFlow invoke : check.trackedReflectionMethod.getInvokeTypeFlows()) {
                check.apply(invoke);
            }
        }
        if (!this.reflectionCalls.isEmpty()) {
            this.reflectionCalls.add("Aborting stand-alone image build due to reflection use without configuration.");
            this.reflectionFallback = new FallbackImageRequest(this.reflectionCalls);
        }
        if (!this.resourceCalls.isEmpty()) {
            this.resourceCalls.add("Aborting stand-alone image build due to accessing resources without configuration.");
            this.resourceFallback = new FallbackImageRequest(this.resourceCalls);
        }
        if (!this.proxyCalls.isEmpty()) {
            this.proxyCalls.add("Aborting stand-alone image build due to dynamic proxy use without configuration.");
            this.proxyFallback = new FallbackImageRequest(this.proxyCalls);
        }
    }

    public static final class FallbackImageRequest
    extends UserError.UserException {
        private FallbackImageRequest(String message) {
            super(message);
        }

        private FallbackImageRequest(Iterable<String> messages) {
            super(messages);
        }
    }

    public static class Options {
        public static final int ForceFallback = 10;
        public static final int Automatic = 5;
        public static final int NoFallback = 0;
        public static final String OptionNameForceFallback = "force-fallback";
        public static final String OptionNameAutoFallback = "auto-fallback";
        public static final String OptionNameNoFallback = "no-fallback";
        @APIOption.List(value={@APIOption(name="force-fallback", fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name="auto-fallback", fixedValue={"5"}, customHelp="build stand-alone image if possible"), @APIOption(name="no-fallback", fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
        @Option(help={"Define when fallback-image generation should be used."})
        public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    }

    private static class ReflectionInvocationCheck {
        private final Method reflectionMethod;
        private final InvokeChecker checker;
        private AnalysisMethod trackedReflectionMethod;

        ReflectionInvocationCheck(Method reflectionMethod, InvokeChecker checker) {
            this.reflectionMethod = reflectionMethod;
            this.checker = checker;
            this.trackedReflectionMethod = null;
        }

        void trackMethod(AnalysisMetaAccess metaAccess) {
            this.trackedReflectionMethod = metaAccess.lookupJavaMethod((Executable)this.reflectionMethod);
            this.trackedReflectionMethod.startTrackInvocations();
        }

        void apply(InvokeTypeFlow invoke) {
            ClassLoader classLoader = FallbackFeature.getCallerMethod(invoke).getDeclaringClass().getJavaClass().getClassLoader();
            if (classLoader instanceof NativeImageClassLoader) {
                this.checker.check(this, invoke);
            }
        }

        String locationString(InvokeTypeFlow invoke) {
            AnalysisMethod caller = FallbackFeature.getCallerMethod(invoke);
            String callerLocation = caller.asStackTraceElement(invoke.getLocation().getBci()).toString();
            return this.trackedReflectionMethod.format("%H.%n") + " invoked at " + callerLocation;
        }
    }

    private static interface InvokeChecker {
        public void check(ReflectionInvocationCheck var1, InvokeTypeFlow var2);
    }

    private static class AutoProxyInvoke {
        private final ResolvedJavaMethod method;
        private final int bci;

        AutoProxyInvoke(ResolvedJavaMethod method, int bci) {
            this.method = method;
            this.bci = bci;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoProxyInvoke that = (AutoProxyInvoke)o;
            return this.bci == that.bci && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.bci);
        }
    }
}

