/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.Uninterruptible;

public final class RingBuffer<T> {
    private static int defaultBufferSize = 30;
    private final T[] entries;
    private int pos;
    private boolean wrapped;

    public RingBuffer() {
        this(defaultBufferSize);
    }

    public RingBuffer(int numEntries) {
        this.entries = new Object[numEntries];
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private int advance(int p) {
        return (p + 1) % this.entries.length;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public void append(T entry) {
        this.entries[this.pos] = entry;
        int posNext = this.advance(this.pos);
        if (posNext <= this.pos) {
            this.wrapped = true;
        }
        this.pos = posNext;
    }

    public void foreach(Consumer<T> consumer) {
        this.foreach(null, consumer);
    }

    public void foreach(Object context, Consumer<T> consumer) {
        if (this.wrapped) {
            int i = this.pos;
            do {
                consumer.accept(context, this.entries[i]);
            } while ((i = this.advance(i)) != this.pos);
        } else {
            for (int i = 0; i < this.pos; ++i) {
                consumer.accept(context, this.entries[i]);
            }
        }
    }

    public static interface Consumer<T> {
        public void accept(Object var1, T var2);
    }
}

