/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.ZLib;
import java.util.zip.Adler32;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
@TargetClass(value=Adler32.class)
final class Target_java_util_zip_Adler32 {
    Target_java_util_zip_Adler32() {
    }

    @Substitute
    private static int update(int adler, int b) {
        CCharPointer bytes = (CCharPointer)StackValue.get(CCharPointer.class);
        bytes.write((byte)b);
        return (int)ZLib.adler32(WordFactory.unsigned((int)adler), bytes, 1).rawValue();
    }

    @Substitute
    private static int updateBytes(int adler, byte[] b, int off, int len) {
        try (PinnedObject pinned = PinnedObject.create((Object)b);){
            CCharPointer bytes = (CCharPointer)pinned.addressOfArrayElement(off);
            int n = (int)ZLib.adler32(WordFactory.unsigned((int)adler), bytes, len).rawValue();
            return n;
        }
    }

    @Substitute
    private static int updateByteBuffer(int adler, long addr, int off, int len) {
        CCharPointer bytes = (CCharPointer)WordFactory.pointer((long)addr);
        CCharPointer bytesAtOffset = bytes.addressOf(off);
        return (int)ZLib.adler32(WordFactory.unsigned((int)adler), bytesAtOffset, len).rawValue();
    }
}

