/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.jdk.SubstrateOperatingSystemMXBean;
import com.oracle.svm.core.posix.headers.Times;
import com.oracle.svm.core.posix.headers.Unistd;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.LINUX_AND_JNI.class, InternalPlatform.DARWIN_AND_JNI.class})
class PosixSubstrateOperatingSystemMXBean
extends SubstrateOperatingSystemMXBean {
    PosixSubstrateOperatingSystemMXBean() {
    }

    @Override
    public long getProcessCpuTime() {
        long clkTck = Unistd.sysconf(Unistd._SC_CLK_TCK());
        if (clkTck == -1L) {
            return -1L;
        }
        long nsPerTick = TimeUnit.SECONDS.toNanos(1L) / clkTck;
        Times.tms time = (Times.tms)StackValue.get(Times.tms.class);
        Times.times(time);
        return (time.tms_utime() + time.tms_stime()) * nsPerTick;
    }
}

