/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

@TargetClass(value=ForkJoinPool.class)
final class Target_java_util_concurrent_ForkJoinPool {
    @Alias
    static int MAX_CAP;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    static int LIFO_QUEUE;
    @Alias
    static ForkJoinPool.ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    @Alias
    @InjectAccessors(value=CommonInjector.class)
    static ForkJoinPool common;
    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    static int commonParallelism;
    @Alias
    @TargetElement(onlyWith={JDK9OrLater.class})
    static int COMMON_PARALLELISM;

    @Alias
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    protected Target_java_util_concurrent_ForkJoinPool(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, int mode, String workerNamePrefix) {
    }

    @Alias
    @TargetElement(onlyWith={JDK9OrLater.class})
    private Target_java_util_concurrent_ForkJoinPool(byte forCommonPoolOnly) {
    }

    @Substitute
    public static int getCommonPoolParallelism() {
        CommonInjector.ensureCommonPoolIsInitialized();
        return commonParallelism;
    }

    protected static class Util_java_util_concurrent_ForkJoinPool {
        protected Util_java_util_concurrent_ForkJoinPool() {
        }

        static ForkJoinPool as_ForkJoinPool(Target_java_util_concurrent_ForkJoinPool tjucfjp) {
            return KnownIntrinsics.unsafeCast(tjucfjp, ForkJoinPool.class);
        }

        static Target_java_util_concurrent_ForkJoinPool as_Target_java_util_concurrent_ForkJoinPool(ForkJoinPool forkJoinPool) {
            return KnownIntrinsics.unsafeCast(forkJoinPool, Target_java_util_concurrent_ForkJoinPool.class);
        }
    }

    protected static class CommonInjector {
        protected static AtomicReference<Target_java_util_concurrent_ForkJoinPool> injectedCommon = new AtomicReference<Object>(null);

        protected CommonInjector() {
        }

        public static ForkJoinPool getCommon() {
            CommonInjector.ensureCommonPoolIsInitialized();
            return Util_java_util_concurrent_ForkJoinPool.as_ForkJoinPool(injectedCommon.get());
        }

        protected static void ensureCommonPoolIsInitialized() {
            if (injectedCommon.get() == null) {
                if (JavaVersionUtil.Java8OrEarlier) {
                    CommonInjector.initializeCommonPool_JDK8OrEarlier();
                } else {
                    CommonInjector.initializeCommonPool_JDK9OrLater();
                }
            }
        }

        protected static void initializeCommonPool_JDK8OrEarlier() {
            int parallelism = Runtime.getRuntime().availableProcessors() - 1;
            if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                parallelism = 0;
            }
            if (parallelism > MAX_CAP) {
                parallelism = MAX_CAP;
            }
            Target_java_util_concurrent_ForkJoinPool proposedPool = new Target_java_util_concurrent_ForkJoinPool(parallelism, defaultForkJoinWorkerThreadFactory, null, LIFO_QUEUE, "ForkJoinPool.commonPool-worker-");
            injectedCommon.compareAndSet(null, proposedPool);
            ForkJoinPool actualPool = Util_java_util_concurrent_ForkJoinPool.as_ForkJoinPool(injectedCommon.get());
            commonParallelism = actualPool.getParallelism();
        }

        protected static void initializeCommonPool_JDK9OrLater() {
            throw VMError.unsupportedFeature("Target_java_util_concurrent_ForkJoinPool.CommonInjector.initializeCommonPool_JDK9OrLater()");
        }
    }
}

