/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class NativeImageInfo {
    public static Object firstReadOnlyPrimitiveObject;
    public static Object lastReadOnlyPrimitiveObject;
    public static Object firstReadOnlyReferenceObject;
    public static Object lastReadOnlyReferenceObject;
    public static Object firstWritablePrimitiveObject;
    public static Object lastWritablePrimitiveObject;
    public static Object firstWritableReferenceObject;
    public static Object lastWritableReferenceObject;

    public static boolean isInReadOnlyPrimitivePartition(Pointer ptr) {
        boolean result = Word.objectToUntrackedPointer((Object)firstReadOnlyPrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)lastReadOnlyPrimitiveObject));
        return result;
    }

    public static boolean isInWritablePrimitivePartition(Pointer ptr) {
        boolean result = Word.objectToUntrackedPointer((Object)firstWritablePrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)lastWritablePrimitiveObject));
        return result;
    }

    public static boolean isInReadOnlyReferencePartition(Pointer ptr) {
        boolean result = Word.objectToUntrackedPointer((Object)firstReadOnlyReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)lastReadOnlyReferenceObject));
        return result;
    }

    public static boolean isInWritableReferencePartition(Pointer ptr) {
        boolean result = Word.objectToUntrackedPointer((Object)firstWritableReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)lastWritableReferenceObject));
        return result;
    }

    public static boolean isObjectInReadOnlyPrimitivePartition(Object obj) {
        return NativeImageInfo.isInReadOnlyPrimitivePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public static boolean isObjectInWritablePrimitivePartition(Object obj) {
        return NativeImageInfo.isInWritablePrimitivePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public static boolean isObjectInReadOnlyReferencePartition(Object obj) {
        return NativeImageInfo.isInReadOnlyReferencePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public static boolean isObjectInWritableReferencePartition(Object obj) {
        return NativeImageInfo.isInWritableReferencePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public static void voidApplyFromObjects(VoidReduceFromObjects lambda) {
        lambda.voidFromObjects(firstReadOnlyPrimitiveObject, lastReadOnlyPrimitiveObject);
        lambda.voidFromObjects(firstReadOnlyReferenceObject, lastReadOnlyReferenceObject);
        lambda.voidFromObjects(firstWritablePrimitiveObject, lastWritablePrimitiveObject);
        lambda.voidFromObjects(firstWritableReferenceObject, lastWritableReferenceObject);
    }

    public static void voidApplyFromPointers(VoidReduceFromPointers lambda) {
        lambda.voidFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstReadOnlyPrimitiveObject), (Pointer)Word.objectToUntrackedPointer((Object)lastReadOnlyPrimitiveObject));
        lambda.voidFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstReadOnlyReferenceObject), (Pointer)Word.objectToUntrackedPointer((Object)lastReadOnlyReferenceObject));
        lambda.voidFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstWritablePrimitiveObject), (Pointer)Word.objectToUntrackedPointer((Object)lastWritablePrimitiveObject));
        lambda.voidFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstWritableReferenceObject), (Pointer)Word.objectToUntrackedPointer((Object)lastWritableReferenceObject));
    }

    public static boolean andReduceFromObjects(BoolReduceFromObjects lambda) {
        boolean result = true;
        result &= lambda.boolFromObjects(firstReadOnlyPrimitiveObject, lastReadOnlyPrimitiveObject);
        result &= lambda.boolFromObjects(firstReadOnlyReferenceObject, lastReadOnlyReferenceObject);
        result &= lambda.boolFromObjects(firstWritablePrimitiveObject, lastWritablePrimitiveObject);
        return result &= lambda.boolFromObjects(firstWritableReferenceObject, lastWritableReferenceObject);
    }

    public static boolean andReduceFromPointers(BoolReduceFromPointers lambda) {
        boolean result = true;
        result &= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstReadOnlyPrimitiveObject), (Pointer)Word.objectToUntrackedPointer((Object)lastReadOnlyPrimitiveObject));
        result &= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstReadOnlyReferenceObject), (Pointer)Word.objectToUntrackedPointer((Object)lastReadOnlyReferenceObject));
        result &= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstWritablePrimitiveObject), (Pointer)Word.objectToUntrackedPointer((Object)lastWritablePrimitiveObject));
        return result &= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstWritableReferenceObject), (Pointer)Word.objectToUntrackedPointer((Object)lastWritableReferenceObject));
    }

    public static boolean orReduceFromObjects(BoolReduceFromObjects lambda) {
        boolean result = false;
        result |= lambda.boolFromObjects(firstReadOnlyPrimitiveObject, lastReadOnlyPrimitiveObject);
        result |= lambda.boolFromObjects(firstReadOnlyReferenceObject, lastReadOnlyReferenceObject);
        result |= lambda.boolFromObjects(firstWritablePrimitiveObject, lastWritablePrimitiveObject);
        return result |= lambda.boolFromObjects(firstWritableReferenceObject, lastWritableReferenceObject);
    }

    public static boolean orReduceFromPointers(BoolReduceFromPointers lambda) {
        boolean result = false;
        result |= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstReadOnlyPrimitiveObject), (Pointer)Word.objectToUntrackedPointer((Object)lastReadOnlyPrimitiveObject));
        result |= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstReadOnlyReferenceObject), (Pointer)Word.objectToUntrackedPointer((Object)lastReadOnlyReferenceObject));
        result |= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstWritablePrimitiveObject), (Pointer)Word.objectToUntrackedPointer((Object)lastWritablePrimitiveObject));
        return result |= lambda.boolFromPointers((Pointer)Word.objectToUntrackedPointer((Object)firstWritableReferenceObject), (Pointer)Word.objectToUntrackedPointer((Object)lastWritableReferenceObject));
    }

    public static boolean walkNativeImageHeap(MemoryWalker.Visitor visitor) {
        MemoryWalker.NativeImageHeapRegionAccess access;
        boolean continueVisiting = true;
        if (continueVisiting) {
            access = (MemoryWalker.NativeImageHeapRegionAccess)ImageSingletons.lookup(ReadOnlyPrimitiveMemoryWalkerAccessImpl.class);
            continueVisiting = visitor.visitNativeImageHeapRegion(NativeImageHeapRegion.READ_ONLY_PRIMITIVE, access);
        }
        if (continueVisiting) {
            access = (MemoryWalker.NativeImageHeapRegionAccess)ImageSingletons.lookup(ReadOnlyReferenceMemoryWalkerAccessImpl.class);
            continueVisiting = visitor.visitNativeImageHeapRegion(NativeImageHeapRegion.READ_ONLY_REFERENCE, access);
        }
        if (continueVisiting) {
            access = (MemoryWalker.NativeImageHeapRegionAccess)ImageSingletons.lookup(WritablePrimitiveMemoryWalkerAccessImpl.class);
            continueVisiting = visitor.visitNativeImageHeapRegion(NativeImageHeapRegion.WRITABLE_PRIMITIVE, access);
        }
        if (continueVisiting) {
            access = (MemoryWalker.NativeImageHeapRegionAccess)ImageSingletons.lookup(WritableReferenceMemoryWalkerAccessImpl.class);
            continueVisiting = visitor.visitNativeImageHeapRegion(NativeImageHeapRegion.WRITABLE_REFERENCE, access);
        }
        return continueVisiting;
    }

    public static boolean walkNativeImageHeap(ObjectVisitor visitor) {
        if (!NativeImageInfo.walkNativeImagePartition(firstReadOnlyPrimitiveObject, lastReadOnlyPrimitiveObject, visitor)) {
            return false;
        }
        if (!NativeImageInfo.walkNativeImagePartition(firstReadOnlyReferenceObject, lastReadOnlyReferenceObject, visitor)) {
            return false;
        }
        if (!NativeImageInfo.walkNativeImagePartition(firstWritablePrimitiveObject, lastWritablePrimitiveObject, visitor)) {
            return false;
        }
        return NativeImageInfo.walkNativeImagePartition(firstWritableReferenceObject, lastWritableReferenceObject, visitor);
    }

    private static boolean walkNativeImagePartition(Object firstObject, Object lastObject, ObjectVisitor visitor) {
        if (firstObject == null || lastObject == null) {
            return true;
        }
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        while (current.belowOrEqual((UnsignedWord)lastPointer)) {
            Object currentObject = KnownIntrinsics.convertUnknownValue(current.toObject(), Object.class);
            if (!visitor.visitObject(currentObject)) {
                return false;
            }
            current = LayoutEncoding.getObjectEnd(currentObject);
        }
        return true;
    }

    protected static class WritableReferenceMemoryWalkerAccessImpl
    extends BaseMemoryWalkerAccessImpl
    implements MemoryWalker.NativeImageHeapRegionAccess<NativeImageHeapRegion> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected WritableReferenceMemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(NativeImageHeapRegion region) {
            return this.baseGetStart(firstWritableReferenceObject);
        }

        @Override
        public UnsignedWord getSize(NativeImageHeapRegion region) {
            return this.baseGetSize(firstWritableReferenceObject, lastWritableReferenceObject);
        }

        @Override
        public String getRegion(NativeImageHeapRegion region) {
            return "writable references";
        }
    }

    protected static class WritablePrimitiveMemoryWalkerAccessImpl
    extends BaseMemoryWalkerAccessImpl
    implements MemoryWalker.NativeImageHeapRegionAccess<NativeImageHeapRegion> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected WritablePrimitiveMemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(NativeImageHeapRegion region) {
            return this.baseGetStart(firstWritablePrimitiveObject);
        }

        @Override
        public UnsignedWord getSize(NativeImageHeapRegion region) {
            return this.baseGetSize(firstWritablePrimitiveObject, lastWritablePrimitiveObject);
        }

        @Override
        public String getRegion(NativeImageHeapRegion region) {
            return "writable primitives";
        }
    }

    protected static class ReadOnlyReferenceMemoryWalkerAccessImpl
    extends BaseMemoryWalkerAccessImpl
    implements MemoryWalker.NativeImageHeapRegionAccess<NativeImageHeapRegion> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected ReadOnlyReferenceMemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(NativeImageHeapRegion region) {
            return this.baseGetStart(firstReadOnlyReferenceObject);
        }

        @Override
        public UnsignedWord getSize(NativeImageHeapRegion region) {
            return this.baseGetSize(firstReadOnlyReferenceObject, lastReadOnlyReferenceObject);
        }

        @Override
        public String getRegion(NativeImageHeapRegion region) {
            return "read-only references";
        }
    }

    protected static class ReadOnlyPrimitiveMemoryWalkerAccessImpl
    extends BaseMemoryWalkerAccessImpl
    implements MemoryWalker.NativeImageHeapRegionAccess<NativeImageHeapRegion> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected ReadOnlyPrimitiveMemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(NativeImageHeapRegion region) {
            return this.baseGetStart(firstReadOnlyPrimitiveObject);
        }

        @Override
        public UnsignedWord getSize(NativeImageHeapRegion region) {
            return this.baseGetSize(firstReadOnlyPrimitiveObject, lastReadOnlyPrimitiveObject);
        }

        @Override
        public String getRegion(NativeImageHeapRegion region) {
            return "read-only primitives";
        }
    }

    protected static class BaseMemoryWalkerAccessImpl {
        protected BaseMemoryWalkerAccessImpl() {
        }

        protected UnsignedWord baseGetStart(Object firstObject) {
            return Word.objectToUntrackedPointer((Object)firstObject);
        }

        protected UnsignedWord baseGetSize(Object firstObject, Object lastObject) {
            Word firstStart = Word.objectToUntrackedPointer((Object)firstObject);
            Pointer lastEnd = LayoutEncoding.getObjectEnd(lastObject);
            return lastEnd.subtract((UnsignedWord)firstStart);
        }
    }

    public static enum NativeImageHeapRegion {
        READ_ONLY_PRIMITIVE,
        READ_ONLY_REFERENCE,
        WRITABLE_PRIMITIVE,
        WRITABLE_REFERENCE;

    }

    public static interface BoolReduceFromPointers {
        public boolean boolFromPointers(Pointer var1, Pointer var2);
    }

    public static interface BoolReduceFromObjects {
        public boolean boolFromObjects(Object var1, Object var2);
    }

    public static interface VoidReduceFromPointers {
        public void voidFromPointers(Pointer var1, Pointer var2);
    }

    public static interface VoidReduceFromObjects {
        public void voidFromObjects(Object var1, Object var2);
    }
}

