/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.heap.InstanceReferenceMapDecoder;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectReferenceWalker;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class VMThreadLocalMTObjectReferenceWalker
extends ObjectReferenceWalker {
    @UnknownPrimitiveField
    public int vmThreadSize = -1;
    @UnknownObjectField(types={byte[].class})
    public byte[] vmThreadReferenceMapEncoding;
    @UnknownPrimitiveField
    public long vmThreadReferenceMapIndex;

    @Override
    public boolean walk(ObjectReferenceVisitor referenceVisitor) {
        IsolateThread vmThread = VMThreads.firstThread();
        while (VMThreads.isNonNullThread(vmThread)) {
            if (!InstanceReferenceMapDecoder.walkOffsetsFromPointer((Pointer)vmThread, this.vmThreadReferenceMapEncoding, this.vmThreadReferenceMapIndex, referenceVisitor)) {
                return false;
            }
            vmThread = VMThreads.nextThread(vmThread);
        }
        return true;
    }

    @Override
    public boolean containsPointer(Pointer p) {
        IsolateThread vmThread = VMThreads.firstThread();
        while (VMThreads.isNonNullThread(vmThread)) {
            Pointer threadPtr = (Pointer)vmThread;
            if (p.aboveOrEqual((UnsignedWord)threadPtr) && p.belowThan((UnsignedWord)threadPtr.add(this.vmThreadSize))) {
                return true;
            }
            vmThread = VMThreads.nextThread(vmThread);
        }
        return false;
    }
}

