/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

public class SubstrateForeignCallsProvider
implements ArrayCopyForeignCalls {
    private final Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls = new HashMap<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateForeignCallsProvider() {
    }

    public Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> getForeignCalls() {
        return this.foreignCalls;
    }

    public SubstrateForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        SubstrateForeignCallLinkage callTarget = this.foreignCalls.get(descriptor);
        if (callTarget == null) {
            throw VMError.shouldNotReachHere("missing implementation for runtime call: " + descriptor);
        }
        return callTarget;
    }

    public boolean isAvailable(ForeignCallDescriptor descriptor) {
        return this.foreignCalls.containsKey(descriptor);
    }

    public boolean isReexecutable(ForeignCallDescriptor descriptor) {
        return this.lookupForeignCall(descriptor).getDescriptor().isReexecutable();
    }

    public LocationIdentity[] getKilledLocations(ForeignCallDescriptor descriptor) {
        return this.lookupForeignCall(descriptor).getDescriptor().getKilledLocations();
    }

    public boolean canDeoptimize(ForeignCallDescriptor descriptor) {
        return true;
    }

    public boolean isGuaranteedSafepoint(ForeignCallDescriptor descriptor) {
        return true;
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind((Architecture)((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch, (JavaKind)javaKind);
    }

    public ForeignCallDescriptor lookupCheckcastArraycopyDescriptor(boolean uninit) {
        throw VMError.unsupportedFeature("Fast ArrayCopy not supported yet.");
    }

    public ForeignCallDescriptor lookupArraycopyDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, boolean killAny) {
        throw VMError.unsupportedFeature("Fast ArrayCopy not supported yet.");
    }
}

