/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code.aarch64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.aarch64.SubstrateAArch64Backend;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AArch64.class})
class SubstrateAArch64BackendFeature
implements Feature {
    SubstrateAArch64BackendFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Platform.includedIn(Platform.AArch64.class) && SubstrateOptions.CompilerBackend.getValue().equals("lir");
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(){

            @Override
            public SubstrateBackend newBackend(Providers newProviders) {
                return new SubstrateAArch64Backend(newProviders);
            }
        });
    }
}

