/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;

public class Latch
implements AutoCloseable {
    protected boolean state;
    protected final String name;

    public static Latch factory(String name) {
        return new Latch(name);
    }

    public Latch open() {
        assert (!this.state) : "Already open.";
        this.state = true;
        return this;
    }

    @Override
    public void close() {
        assert (this.state) : "Already closed.";
        this.state = false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    protected Latch(String name) {
        this.name = name;
        this.state = false;
    }
}

