/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.InvalidInstalledCodeException;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;

class SubstrateTruffleInstalledCodeBridge
extends InstalledCode
implements OptimizedAssumptionDependency.Access,
SubstrateInstalledCode.Access {
    private final SubstrateOptimizedCallTarget callTarget;
    private static final String NOT_CALLED_IN_SUBSTRATE_VM = "No implementation in Substrate VM";

    SubstrateTruffleInstalledCodeBridge(SubstrateOptimizedCallTarget callTarget) {
        super(callTarget.getName());
        this.callTarget = callTarget;
    }

    @Override
    public SubstrateInstalledCode getSubstrateInstalledCode() {
        return this.callTarget;
    }

    public OptimizedAssumptionDependency getDependency() {
        return this.callTarget;
    }

    public String toString() {
        return this.callTarget.toString();
    }

    public void invalidate() {
        this.callTarget.invalidate();
    }

    public boolean isValid() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public boolean isAlive() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public String getName() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public long getStart() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public byte[] getCode() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public Object executeVarargs(Object ... args) throws InvalidInstalledCodeException {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }
}

