/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethod;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class JNIJavaCallWrappers {
    public static ConstantPool getConstantPool(MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(JNIJavaCallWrappers.class).getDeclaredConstructors()[0].getConstantPool();
    }

    public static ResolvedJavaMethod lookupJavaCallTrampoline(MetaAccessProvider metaAccess, JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        StringBuilder name = new StringBuilder(48);
        if (variant == JNIJavaCallWrapperMethod.CallVariant.VARARGS) {
            name.append("varargs");
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.ARRAY) {
            name.append("array");
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.VA_LIST) {
            name.append("valist");
        } else {
            throw VMError.shouldNotReachHere();
        }
        if (nonVirtual) {
            name.append("Nonvirtual");
        }
        name.append("JavaCallTrampoline");
        try {
            return metaAccess.lookupJavaMethod((Executable)JNIJavaCallWrappers.class.getDeclaredMethod(name.toString(), new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private JNIJavaCallWrappers() {
    }

    private native void varargsJavaCallTrampoline();

    private native void arrayJavaCallTrampoline();

    private native void valistJavaCallTrampoline();

    private native void varargsNonvirtualJavaCallTrampoline();

    private native void arrayNonvirtualJavaCallTrampoline();

    private native void valistNonvirtualJavaCallTrampoline();
}

