/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.nodes.AssertValueNode;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class InliningUtilities {
    private static final Class<? extends Annotation> JDK_FORCE_INLINE_ANNOTATION = InliningUtilities.lookupForceInlineAnnotation();

    private static Class<? extends Annotation> lookupForceInlineAnnotation() {
        try {
            if (JavaVersionUtil.Java8OrEarlier) {
                return Class.forName("java.lang.invoke.ForceInline");
            }
            return Class.forName("jdk.internal.vm.annotation.ForceInline");
        }
        catch (ClassNotFoundException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static boolean isTrivialMethod(StructuredGraph graph) {
        if (graph.method().getAnnotation(JDK_FORCE_INLINE_ANNOTATION) != null) {
            return true;
        }
        int numInvokes = 0;
        int numOthers = 0;
        for (Node n : graph.getNodes()) {
            if (n instanceof StartNode || n instanceof ParameterNode || n instanceof FullInfopointNode || n instanceof ValueProxy || n instanceof AssertValueNode) continue;
            if (n instanceof MethodCallTargetNode) {
                ++numInvokes;
            } else {
                ++numOthers;
            }
            if (InliningUtilities.shouldBeTrivial(numInvokes, numOthers, graph)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldBeTrivial(int numInvokes, int numOthers, StructuredGraph graph) {
        if (numInvokes == 0) {
            return numOthers <= (Integer)SubstrateOptions.MaxNodesInTrivialLeafMethod.getValue(graph.getOptions());
        }
        if (numInvokes <= (Integer)SubstrateOptions.MaxInvokesInTrivialMethod.getValue(graph.getOptions())) {
            return numOthers <= (Integer)SubstrateOptions.MaxNodesInTrivialMethod.getValue(graph.getOptions());
        }
        return false;
    }

    public static int recursionDepth(Invoke invoke, ResolvedJavaMethod callee) {
        FrameState state = invoke.stateAfter();
        int result = 0;
        do {
            if (!state.getMethod().equals(callee)) continue;
            ++result;
        } while ((state = state.outerFrameState()) != null);
        return result;
    }
}

