/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.Target_sun_nio_fs_WindowsFileSystemProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.spi.FileSystemProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.WINDOWS.class})
public final class WindowsJavaNIOSubstitutions {
    private static URI uri = WindowsJavaNIOSubstitutions.createURI();

    public static boolean initIDs() {
        return true;
    }

    private static URI createURI() {
        try {
            return new URI("file:/");
        }
        catch (URISyntaxException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    @TargetClass(className="sun.nio.fs.Cancellable")
    @Platforms(value={Platform.WINDOWS.class})
    static final class Target_sun_nio_fs_Cancellable {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Manual)
        private long pollingAddress;

        Target_sun_nio_fs_Cancellable() {
        }
    }

    @TargetClass(value=FileSystems.class)
    @Platforms(value={Platform.WINDOWS.class})
    static final class Target_java_nio_file_FileSystems {
        Target_java_nio_file_FileSystems() {
        }

        @Substitute
        static FileSystem getDefault() {
            if (Util_Target_java_nio_file_FileSystems.defaultFilesystem == null) {
                Target_sun_nio_fs_WindowsFileSystemProvider provider = new Target_sun_nio_fs_WindowsFileSystemProvider();
                Util_Target_java_nio_file_FileSystems.defaultProvider = KnownIntrinsics.unsafeCast(provider, FileSystemProvider.class);
                Util_Target_java_nio_file_FileSystems.defaultFilesystem = provider.getFileSystem(uri);
            }
            return Util_Target_java_nio_file_FileSystems.defaultFilesystem;
        }

        @Delete
        @TargetClass(value=FileSystems.class, innerClass={"DefaultFileSystemHolder"})
        static final class Target_java_nio_file_FileSystems_DefaultFileSystemHolder {
            Target_java_nio_file_FileSystems_DefaultFileSystemHolder() {
            }
        }
    }

    static final class Util_Target_java_nio_file_FileSystems {
        static FileSystemProvider defaultProvider;
        static FileSystem defaultFilesystem;

        Util_Target_java_nio_file_FileSystems() {
        }
    }
}

