/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.headers.Sysctl;
import com.oracle.svm.core.posix.headers.darwin.DarwinSysctl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={InternalPlatform.DARWIN_AND_JNI.class})
class DarwinPhysicalMemory
extends PhysicalMemory {
    DarwinPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new PhysicalMemorySupportImpl());
        }
    }

    static class PhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        static final long UNSET_SENTINEL = Long.MIN_VALUE;
        long cachedSize = Long.MIN_VALUE;

        PhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            if (this.hasSize()) {
                return this.getSize();
            }
            CIntPointer namePointer = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
            namePointer.write(0, DarwinSysctl.CTL_HW());
            namePointer.write(1, DarwinSysctl.HW_MEMSIZE());
            CLongPointer physicalMemoryPointer = (CLongPointer)StackValue.get(CLongPointer.class);
            CLongPointer physicalMemorySizePointer = (CLongPointer)StackValue.get(CLongPointer.class);
            physicalMemorySizePointer.write((long)SizeOf.get(CLongPointer.class));
            int sysctlResult = Sysctl.sysctl(namePointer, 2L, (PointerBase)physicalMemoryPointer, (WordPointer)physicalMemorySizePointer, WordFactory.nullPointer(), 0L);
            if (sysctlResult != 0) {
                Log.log().string("DarwinPhysicalMemory.PhysicalMemorySupportImpl.size(): sysctl() returns with errno: ").signed(Errno.errno()).newline();
                VMError.shouldNotReachHere("DarwinPhysicalMemory.PhysicalMemorySupportImpl.size() failed.");
            }
            this.setSize(physicalMemoryPointer.read());
            return this.getSize();
        }

        @Override
        public boolean hasSize() {
            return this.cachedSize != Long.MIN_VALUE;
        }

        void setSize(long value) {
            this.cachedSize = value;
        }

        UnsignedWord getSize() {
            assert (this.hasSize()) : "DarwinPhysicalMemory.PhysicalMemorySupportImpl.getValue(): cachedSize has no value.";
            return WordFactory.unsigned((long)this.cachedSize);
        }
    }
}

