/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jni.JNIRuntimeAccess;
import java.net.InetAddress;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={InternalPlatform.LINUX_JNI.class, InternalPlatform.DARWIN_JNI.class})
@AutomaticFeature
@CLibrary(value="net")
class PosixJavaNetSubstitutionsFeature
implements Feature {
    PosixJavaNetSubstitutionsFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        try {
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.InetAddress"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.Inet4AddressImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.Inet6AddressImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.SocketInputStream"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.SocketOutputStream"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.DatagramPacket"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.AbstractPlainSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.PlainSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.PlainDatagramSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("sun.net.ExtendedOptionsImpl"), "required for substitutions");
        }
        catch (Exception e) {
            VMError.shouldNotReachHere("PosixJavaNetSubstitutionsFeature: Error registering rerunClassInitialization: ", e);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("name"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("displayName"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("index"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("addrs"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("bindings"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("childs"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("virtual"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("parent"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("defaultIndex"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredField("broadcast"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredField("maskLength"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredField("holder"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredField("preferIPv6Address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredMethod("anyLocalAddress", new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer").getDeclaredField("addr"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("family"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("hostName"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("originalHostName"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet4Address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet4Address").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address").getDeclaredField("holder6"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address").getDeclaredField("cached_scope_id"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("ipaddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("scope_id"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("scope_id_set"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("scope_ifname"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("port"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("buf"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("offset"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("length"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("bufLength"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress").getDeclaredConstructor(InetAddress.class, Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketException"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketException").getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.ConnectException"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.ConnectException").getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketInputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketOutputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl").getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl").getDeclaredField("localPort"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("timeout"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("trafficClass"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("connected"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("connectedAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("connectedPort"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.PlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("localport"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("serverSocket"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("port"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl").getDeclaredField("timeout"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl").getDeclaredField("trafficClass"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl").getDeclaredField("fdLock"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl").getDeclaredField("closePending"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.PlainSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow").getDeclaredField("status"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow").getDeclaredField("priority"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow").getDeclaredField("bandwidth"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("NO_STATUS"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("OK"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("NO_PERMISSION"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("NOT_CONNECTED"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("NOT_SUPPORTED"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("ALREADY_CREATED"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("IN_PROGRESS"));
            JNIRuntimeAccess.register(access.findClassByName("jdk.net.SocketFlow$Status").getDeclaredField("OTHER"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredConstructor(Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredField("value"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredConstructor(Boolean.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredMethod("getBoolean", String.class));
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.InetAddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
        }
        catch (Exception e) {
            VMError.shouldNotReachHere("PosixJavaNetSubstitutionsFeature: Error registering class or method: ", e);
        }
    }
}

