/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.snippets.SnippetRuntime;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateForeignCallLinkage
implements ForeignCallLinkage {
    private final SnippetRuntime.SubstrateForeignCallDescriptor descriptor;
    private final CallingConvention outgoingCallingConvention;
    private final CallingConvention incomingCallingConvention;
    private final ResolvedJavaMethod method;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateForeignCallLinkage(Providers providers, SnippetRuntime.SubstrateForeignCallDescriptor descriptor) {
        this.descriptor = descriptor;
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        CodeCacheProvider codeCache = providers.getCodeCache();
        if (codeCache != null) {
            RegisterConfig registerConfig = codeCache.getRegisterConfig();
            final Architecture arch = codeCache.getTarget().arch;
            ValueKindFactory<LIRKind> valueKindFactory = new ValueKindFactory<LIRKind>(){

                public LIRKind getValueKind(JavaKind javaKind) {
                    return LIRKind.fromJavaKind((Architecture)arch, (JavaKind)javaKind);
                }
            };
            ResolvedJavaType resType = metaAccess.lookupJavaType(descriptor.getResultType());
            ResolvedJavaType[] argTypes = metaAccess.lookupJavaTypes(descriptor.getArgumentTypes());
            this.outgoingCallingConvention = registerConfig.getCallingConvention((CallingConvention.Type)SubstrateCallingConventionType.JavaCall, (JavaType)resType, (JavaType[])argTypes, (ValueKindFactory)valueKindFactory);
            this.incomingCallingConvention = registerConfig.getCallingConvention((CallingConvention.Type)SubstrateCallingConventionType.JavaCallee, (JavaType)resType, (JavaType[])argTypes, (ValueKindFactory)valueKindFactory);
        } else {
            this.outgoingCallingConvention = null;
            this.incomingCallingConvention = null;
        }
        this.method = descriptor.findMethod(metaAccess);
    }

    public CallingConvention getOutgoingCallingConvention() {
        return this.outgoingCallingConvention;
    }

    public CallingConvention getIncomingCallingConvention() {
        return this.incomingCallingConvention;
    }

    public long getMaxCallTargetOffset() {
        return -1L;
    }

    public boolean destroysRegisters() {
        return true;
    }

    public boolean needsDebugInfo() {
        return true;
    }

    public SnippetRuntime.SubstrateForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public Value[] getTemporaries() {
        return AllocatableValue.NONE;
    }

    public String toString() {
        return "RuntimeCall<" + this.descriptor.getDeclaringClass().getSimpleName() + "." + this.descriptor.getName() + ">";
    }
}

