/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.nodes.SubstrateNewArrayNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewInstanceNode;
import com.oracle.svm.core.graal.nodes.SubstrateVirtualArrayNode;
import com.oracle.svm.core.graal.nodes.SubstrateVirtualInstanceNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.DefaultJavaLoweringProvider;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateBasicLoweringProvider
extends DefaultJavaLoweringProvider
implements SubstrateLoweringProvider {
    private final Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings = new HashMap();
    private RuntimeConfiguration runtimeConfig;
    private final AbstractObjectStamp hubStamp;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateBasicLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, TargetDescription target) {
        super(metaAccess, foreignCalls, target, ReferenceAccess.singleton().haveCompressedReferences());
        ObjectStamp hubRefStamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)metaAccess.lookupJavaType(DynamicHub.class)));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            hubRefStamp = SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)hubRefStamp, ReferenceAccess.singleton().getCompressEncoding());
        }
        this.hubStamp = hubRefStamp;
    }

    @Override
    public void setConfiguration(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection) {
        this.runtimeConfig = runtimeConfig;
        this.initialize(options, factories, SnippetCounter.Group.NullFactory, providers, snippetReflection);
    }

    protected Providers getProviders() {
        return this.runtimeConfig.getProviders();
    }

    protected ObjectLayout getObjectLayout() {
        return ConfigurationValues.getObjectLayout();
    }

    @Override
    public Map<Class<? extends Node>, NodeLoweringProvider<?>> getLowerings() {
        return this.lowerings;
    }

    public void lower(Node n, LoweringTool tool) {
        NodeLoweringProvider<?> lowering = this.lowerings.get(n.getClass());
        if (lowering != null) {
            lowering.lower(n, tool);
        } else if (!(n instanceof RemNode)) {
            if (n instanceof AssertionNode) {
                SubstrateBasicLoweringProvider.lowerAssertionNode((AssertionNode)n);
            } else {
                super.lower(n, tool);
            }
        }
    }

    public int arrayLengthOffset() {
        return this.getObjectLayout().getArrayLengthOffset();
    }

    public ValueNode staticFieldBase(StructuredGraph graph, ResolvedJavaField f) {
        SharedField field = (SharedField)f;
        assert (field.isStatic());
        Object[] fields = field.getStorageKind() == JavaKind.Object ? StaticFieldsSupport.getStaticObjectFields() : (Object[])StaticFieldsSupport.getStaticPrimitiveFields();
        return ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(fields), (MetaAccessProvider)this.getProviders().getMetaAccess(), (StructuredGraph)graph);
    }

    private static ValueNode maybeUncompress(ValueNode node) {
        Stamp stamp = node.stamp(NodeView.DEFAULT);
        if (stamp instanceof NarrowOopStamp) {
            return SubstrateCompressionNode.uncompress(node, ((NarrowOopStamp)stamp).getEncoding());
        }
        return node;
    }

    protected ValueNode createReadArrayComponentHub(StructuredGraph graph, ValueNode arrayHub, FixedNode anchor) {
        ConstantNode componentHubOffset = ConstantNode.forIntegerKind((JavaKind)this.target.wordJavaKind, (long)this.runtimeConfig.getComponentHubOffset(), (StructuredGraph)graph);
        AddressNode componentHubAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(arrayHub, (ValueNode)componentHubOffset));
        FloatingReadNode componentHubRef = (FloatingReadNode)graph.unique((Node)new FloatingReadNode(componentHubAddress, NamedLocationIdentity.FINAL_LOCATION, null, (Stamp)this.hubStamp, null, HeapAccess.BarrierType.NONE));
        return SubstrateBasicLoweringProvider.maybeUncompress((ValueNode)componentHubRef);
    }

    protected ValueNode createReadHub(StructuredGraph graph, ValueNode object, LoweringTool tool) {
        ValueNode hubBits;
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return (ValueNode)graph.unique((Node)new LoadHubNode(tool.getStampProvider(), object));
        }
        assert (!object.isConstant() || object.asJavaConstant().isNull());
        IntegerStamp headerBitsStamp = StampFactory.forUnsignedInteger((int)(8 * this.getObjectLayout().getReferenceSize()));
        ConstantNode headerOffset = ConstantNode.forIntegerKind((JavaKind)this.target.wordJavaKind, (long)this.getObjectLayout().getHubOffset(), (StructuredGraph)graph);
        AddressNode headerAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(object, (ValueNode)headerOffset));
        ValueNode headerBits = (ValueNode)graph.unique((Node)new FloatingReadNode(headerAddress, NamedLocationIdentity.FINAL_LOCATION, null, (Stamp)headerBitsStamp, null, HeapAccess.BarrierType.NONE));
        int encodingShift = ReferenceAccess.singleton().getCompressEncoding().getShift();
        if (encodingShift != 0) {
            assert (Long.MAX_VALUE << encodingShift == ObjectHeader.BITS_CLEAR.rawValue()) : "Compression shift must mask object header bits";
            hubBits = (ValueNode)graph.unique((Node)new UnsignedRightShiftNode(headerBits, (ValueNode)ConstantNode.forInt((int)encodingShift, (StructuredGraph)graph)));
        } else {
            hubBits = (ValueNode)graph.unique((Node)new AndNode(headerBits, (ValueNode)ConstantNode.forIntegerStamp((Stamp)headerBitsStamp, (long)ObjectHeader.BITS_CLEAR.rawValue(), (StructuredGraph)graph)));
        }
        FloatingWordCastNode hubRef = (FloatingWordCastNode)graph.unique((Node)new FloatingWordCastNode((Stamp)this.hubStamp, hubBits));
        return SubstrateBasicLoweringProvider.maybeUncompress((ValueNode)hubRef);
    }

    public FieldLocationIdentity fieldLocationIdentity(ResolvedJavaField field) {
        return new SubstrateFieldLocationIdentity(field);
    }

    public int fieldOffset(ResolvedJavaField f) {
        SharedField field = (SharedField)f;
        return field.isAccessed() ? field.getLocation() : -1;
    }

    public NewInstanceNode createNewInstanceFromVirtual(VirtualObjectNode virtual) {
        if (virtual instanceof SubstrateVirtualInstanceNode) {
            return new SubstrateNewInstanceNode(virtual.type(), true, null);
        }
        return super.createNewInstanceFromVirtual(virtual);
    }

    protected NewArrayNode createNewArrayFromVirtual(VirtualObjectNode virtual, ValueNode length) {
        if (virtual instanceof SubstrateVirtualArrayNode) {
            return new SubstrateNewArrayNode(((VirtualArrayNode)virtual).componentType(), length, true, null);
        }
        return super.createNewArrayFromVirtual(virtual, length);
    }

    private static void lowerAssertionNode(AssertionNode n) {
        n.graph().removeFixed((FixedWithNextNode)n);
    }

    protected Stamp loadCompressedStamp(ObjectStamp stamp) {
        return SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)stamp, ReferenceAccess.singleton().getCompressEncoding());
    }

    protected ValueNode newCompressionNode(CompressionNode.CompressionOp op, ValueNode value) {
        return new SubstrateCompressionNode(op, value, ReferenceAccess.singleton().getCompressEncoding());
    }

    protected final JavaKind getStorageKind(ResolvedJavaField field) {
        return ((SharedField)field).getStorageKind();
    }
}

