/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public final class StackVerifier {
    private static final VerifyFrameReferencesVisitor verifyFrameReferencesVisitor = new VerifyFrameReferencesVisitor();
    private final StackFrameVerifierVisitor stackFrameVisitor = new StackFrameVerifierVisitor();

    StackVerifier() {
    }

    public boolean verifyInAllThreads(Pointer currentSp, CodePointer currentIp, String message) {
        Log trace = StackVerifier.getTraceLog();
        trace.string("[StackVerifier.verifyInAllThreads:").string(message).newline();
        ThreadLocalAllocation.disableThreadLocalAllocation();
        trace.string("Current thread ").hex((WordBase)CurrentIsolate.getCurrentThread()).string(": [").newline();
        if (!JavaStackWalker.walkCurrentThread(currentSp, currentIp, this.stackFrameVisitor)) {
            return false;
        }
        trace.string("]").newline();
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (VMThreads.isNonNullThread(vmThread)) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    trace.string("Thread ").hex((WordBase)vmThread).string(": [").newline();
                    if (!JavaStackWalker.walkThread(vmThread, this.stackFrameVisitor)) {
                        return false;
                    }
                    trace.string("]").newline();
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
        trace.string("]").newline();
        return true;
    }

    private static boolean verifyFrame(Pointer frameSP, CodePointer frameIP, DeoptimizedFrame deoptimizedFrame) {
        Log trace = StackVerifier.getTraceLog();
        trace.string("[StackVerifier.verifyFrame:");
        trace.string("  frameSP: ").hex((WordBase)frameSP);
        trace.string("  frameIP: ").hex((WordBase)frameIP);
        trace.string("  pc: ").hex((WordBase)frameIP);
        trace.newline();
        if (!CodeInfoTable.visitObjectReferences(frameSP, frameIP, deoptimizedFrame, verifyFrameReferencesVisitor)) {
            return false;
        }
        trace.string("  returns true]").newline();
        return true;
    }

    private static Log getTraceLog() {
        return HeapOptions.TraceStackVerification.getValue() != false ? Log.log() : Log.noopLog();
    }

    private static class VerifyFrameReferencesVisitor
    implements ObjectReferenceVisitor {
        private VerifyFrameReferencesVisitor() {
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            Word objAddr = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            Log trace = StackVerifier.getTraceLog();
            trace.string("  objAddr: ").hex((WordBase)objAddr);
            trace.newline();
            if (!objAddr.isNull() && !HeapImpl.getHeapImpl().getHeapVerifier().verifyObjectAt((Pointer)objAddr)) {
                Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog();
                witness.string("[StackVerifier.verifyFrame:");
                witness.string("  objAddr: ").hex((WordBase)objAddr);
                witness.string("  fails to verify");
                witness.string("]").newline();
                return false;
            }
            return true;
        }
    }

    private static class StackFrameVerifierVisitor
    implements StackFrameVisitor {
        private StackFrameVerifierVisitor() {
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the stack.")
        public boolean visitFrame(Pointer currentSP, CodePointer currentIP, DeoptimizedFrame deoptimizedFrame) {
            Log trace = StackVerifier.getTraceLog();
            long totalFrameSize = CodeInfoTable.lookupTotalFrameSize(currentIP);
            trace.string("  currentIP: ").hex((WordBase)currentIP);
            trace.string("  currentSP: ").hex((WordBase)currentSP);
            trace.string("  frameSize: ").signed(totalFrameSize).newline();
            if (!StackVerifier.verifyFrame(currentSP, currentIP, deoptimizedFrame)) {
                Log witness = Log.log();
                witness.string("  frame fails to verify");
                witness.string("  returns false]").newline();
                return false;
            }
            return true;
        }
    }
}

