/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class MemoryMXBeanMemoryVisitor
implements MemoryWalker.Visitor {
    private UnsignedWord heapUsed;
    private UnsignedWord heapCommitted;
    private UnsignedWord nonHeapUsed;
    private UnsignedWord nonHeapCommitted;

    MemoryMXBeanMemoryVisitor() {
        this.reset();
    }

    public UnsignedWord getHeapUsed() {
        return this.heapUsed;
    }

    public UnsignedWord getHeapCommitted() {
        return this.heapCommitted;
    }

    public UnsignedWord getNonHeapUsed() {
        return this.nonHeapUsed;
    }

    public UnsignedWord getNonHeapCommitted() {
        return this.nonHeapCommitted;
    }

    public void reset() {
        this.heapUsed = (UnsignedWord)WordFactory.zero();
        this.heapCommitted = (UnsignedWord)WordFactory.zero();
        this.nonHeapUsed = (UnsignedWord)WordFactory.zero();
        this.nonHeapCommitted = (UnsignedWord)WordFactory.zero();
    }

    @Override
    public <T> boolean visitNativeImageHeapRegion(T bootImageHeapRegion, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
        UnsignedWord size = access.getSize(bootImageHeapRegion);
        this.heapUsed = this.heapUsed.add(size);
        this.heapCommitted = this.heapCommitted.add(size);
        return true;
    }

    @Override
    public <T extends PointerBase> boolean visitHeapChunk(T heapChunk, MemoryWalker.HeapChunkAccess<T> access) {
        UnsignedWord used = access.getAllocationEnd(heapChunk).subtract(access.getAllocationStart(heapChunk));
        UnsignedWord committed = access.getSize(heapChunk);
        this.heapUsed = this.heapUsed.add(used);
        this.heapCommitted = this.heapCommitted.add(committed);
        return true;
    }

    @Override
    public <T> boolean visitImageCode(T imageCode, MemoryWalker.ImageCodeAccess<T> access) {
        UnsignedWord size = access.getSize(imageCode);
        this.nonHeapUsed = this.nonHeapUsed.add(size);
        this.nonHeapCommitted = this.nonHeapCommitted.add(size);
        return true;
    }

    @Override
    public <T> boolean visitRuntimeCompiledMethod(T runtimeMethod, MemoryWalker.RuntimeCompiledMethodAccess<T> access) {
        UnsignedWord size = access.getSize(runtimeMethod);
        this.nonHeapUsed = this.nonHeapUsed.add(size);
        this.nonHeapCommitted = this.nonHeapUsed.add(size);
        return true;
    }
}

