/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.DeoptimizationSourcePositionDecoder;
import com.oracle.svm.core.code.RuntimeMethodInfo;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.util.ByteArrayReader;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.util.FrequencyEncoder;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.graph.NodeSourcePosition;

public class DeoptimizationSourcePositionEncoder {
    private final PinnedAllocator allocator;
    private final FrequencyEncoder<Object> objectConstants;
    protected int[] deoptimizationStartOffsets;
    protected byte[] deoptimizationEncodings;
    protected Object[] deoptimizationObjectConstants;

    public DeoptimizationSourcePositionEncoder(PinnedAllocator allocator) {
        this.allocator = allocator;
        this.objectConstants = FrequencyEncoder.createIdentityEncoder();
    }

    public void encode(List<NodeSourcePosition> deoptimzationSourcePositions) {
        this.addObjectConstants(deoptimzationSourcePositions);
        this.deoptimizationObjectConstants = this.objectConstants.encodeAll(this.newObjectArray(this.objectConstants.getLength()));
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        EconomicMap sourcePositionStartOffsets = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        this.deoptimizationStartOffsets = this.newIntArray(deoptimzationSourcePositions.size());
        this.encodeSourcePositions(deoptimzationSourcePositions, (EconomicMap<NodeSourcePosition, Long>)sourcePositionStartOffsets, encodingBuffer);
        this.deoptimizationEncodings = encodingBuffer.toArray(this.newByteArray(TypeConversion.asS4((long)encodingBuffer.getBytesWritten())));
        this.verifyEncoding(deoptimzationSourcePositions);
    }

    public void install(RuntimeMethodInfo target) {
        target.deoptimizationStartOffsets = this.deoptimizationStartOffsets;
        target.deoptimizationEncodings = this.deoptimizationEncodings;
        target.deoptimizationObjectConstants = this.deoptimizationObjectConstants;
    }

    private void addObjectConstants(List<NodeSourcePosition> deoptimzationSourcePositions) {
        EconomicSet processedPositions = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (NodeSourcePosition sourcePosition : deoptimzationSourcePositions) {
            this.addObjectConstants(sourcePosition, (EconomicSet<NodeSourcePosition>)processedPositions);
        }
    }

    private void addObjectConstants(NodeSourcePosition sourcePosition, EconomicSet<NodeSourcePosition> processedPositions) {
        if (sourcePosition == null || processedPositions.contains((Object)sourcePosition)) {
            return;
        }
        this.addObjectConstants(sourcePosition.getCaller(), processedPositions);
        this.objectConstants.addObject((Object)sourcePosition.getMethod());
        processedPositions.add((Object)sourcePosition);
    }

    private void encodeSourcePositions(List<NodeSourcePosition> deoptimzationSourcePositions, EconomicMap<NodeSourcePosition, Long> sourcePositionStartOffsets, UnsafeArrayTypeWriter encodingBuffer) {
        for (int i = 0; i < deoptimzationSourcePositions.size(); ++i) {
            int startOffset;
            NodeSourcePosition sourcePosition = deoptimzationSourcePositions.get(i);
            if (sourcePosition == null) {
                startOffset = -1;
            } else {
                startOffset = TypeConversion.asS4((long)this.encodeSourcePositions(sourcePosition, sourcePositionStartOffsets, encodingBuffer));
                assert (startOffset > -1);
            }
            this.deoptimizationStartOffsets[i] = startOffset;
        }
    }

    private long encodeSourcePositions(NodeSourcePosition sourcePosition, EconomicMap<NodeSourcePosition, Long> sourcePositionStartOffsets, UnsafeArrayTypeWriter encodingBuffer) {
        Long existingAbsoluteOffset = (Long)sourcePositionStartOffsets.get((Object)sourcePosition);
        if (existingAbsoluteOffset != null) {
            return existingAbsoluteOffset;
        }
        long callerAbsoluteOffset = -1L;
        if (sourcePosition.getCaller() != null) {
            callerAbsoluteOffset = this.encodeSourcePositions(sourcePosition.getCaller(), sourcePositionStartOffsets, encodingBuffer);
        }
        long startAbsoluteOffset = encodingBuffer.getBytesWritten();
        long callerRelativeOffset = 0L;
        if (sourcePosition.getCaller() != null) {
            callerRelativeOffset = startAbsoluteOffset - callerAbsoluteOffset;
            assert (callerRelativeOffset > 0L);
        }
        encodingBuffer.putUV(callerRelativeOffset);
        encodingBuffer.putSV((long)sourcePosition.getBCI());
        encodingBuffer.putUV((long)this.objectConstants.getIndex((Object)sourcePosition.getMethod()));
        sourcePositionStartOffsets.put((Object)sourcePosition, (Object)startAbsoluteOffset);
        return startAbsoluteOffset;
    }

    private Object[] newObjectArray(int length) {
        return this.allocator == null ? new Object[length] : (Object[])this.allocator.newArray(Object.class, length);
    }

    private byte[] newByteArray(int length) {
        return this.allocator == null ? new byte[length] : (byte[])this.allocator.newArray(Byte.TYPE, length);
    }

    private int[] newIntArray(int length) {
        return this.allocator == null ? new int[length] : (int[])this.allocator.newArray(Integer.TYPE, length);
    }

    private boolean verifyEncoding(List<NodeSourcePosition> deoptimzationSourcePositions) {
        for (int i = 0; i < deoptimzationSourcePositions.size(); ++i) {
            NodeSourcePosition originalSourcePosition = deoptimzationSourcePositions.get(i);
            NodeSourcePosition decodedSourcePosition = DeoptimizationSourcePositionDecoder.decode(i, this.deoptimizationStartOffsets, this.deoptimizationEncodings, this.deoptimizationObjectConstants);
            this.verifySourcePosition(originalSourcePosition, decodedSourcePosition);
        }
        return true;
    }

    private void verifySourcePosition(NodeSourcePosition originalPosition, NodeSourcePosition decodedSourcePosition) {
        if (originalPosition == null) {
            assert (decodedSourcePosition == null);
            return;
        }
        assert (originalPosition.getBCI() == decodedSourcePosition.getBCI());
        assert (originalPosition.getMethod().equals(decodedSourcePosition.getMethod()));
        this.verifySourcePosition(originalPosition.getCaller(), decodedSourcePosition.getCaller());
    }
}

